/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.Currency;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.CurrencyAmountStr;

public final class CurrencyAmountStrValidator
implements ConstraintValidator<CurrencyAmountStr, String> {
    private static final String DECIMAL = "((\\+|-)?([0-9]+(\\.?[0-9]+)))";
    private static final String INTEGER = "((\\+|-)?[0-9]+)";

    public final void initialize(CurrencyAmountStr constraintAnnotation) {
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        return CurrencyAmountStrValidator.isValid(value);
    }

    public static boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return false;
        }
        int space = value.indexOf(32);
        if (space == -1) {
            return false;
        }
        String amount = value.substring(0, space);
        if (!amount.matches(DECIMAL) && !amount.matches(INTEGER)) {
            return false;
        }
        String currencyCode = value.substring(space + 1);
        try {
            Currency.getInstance(currencyCode);
        }
        catch (RuntimeException ex) {
            return false;
        }
        return true;
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!CurrencyAmountStrValidator.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }
}

