/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.DecryptionFailedException;
import org.fuin.ddd4j.core.ExceptionData;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DecryptionFailedExceptionData
implements ExceptionData<DecryptionFailedException> {
    private static final long serialVersionUID = 1000L;
    @JsonProperty(value="msg")
    private String message;
    @JsonProperty(value="sid")
    private String sid;

    protected DecryptionFailedExceptionData() {
    }

    public DecryptionFailedExceptionData(@NotNull DecryptionFailedException ex) {
        this.message = ex.getMessage();
        this.sid = ex.getShortId();
    }

    @JsonIgnore
    public String getDataElement() {
        return "decryption-failed-exception";
    }

    @JsonIgnore
    public final String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getShortId() {
        return this.sid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecryptionFailedExceptionData other = (DecryptionFailedExceptionData)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    public String toString() {
        return "DecryptionFailedExceptionData [message=" + this.message + ", sid=" + this.sid + "]";
    }

    public DecryptionFailedException toException() {
        return new DecryptionFailedException(this.message);
    }
}

