/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.AbstractAggregateException;
import org.fuin.ddd4j.core.AggregateVersionConflictException;
import org.fuin.ddd4j.jackson.AbstractAggregateExceptionData;

public final class AggregateVersionConflictExceptionData
extends AbstractAggregateExceptionData<AggregateVersionConflictException> {
    private static final long serialVersionUID = 1000L;
    @JsonProperty(value="sid")
    private String sid;
    @JsonProperty(value="expected-version")
    private int expected;
    @JsonProperty(value="actual-version")
    private int actual;

    protected AggregateVersionConflictExceptionData() {
    }

    public AggregateVersionConflictExceptionData(@NotNull AggregateVersionConflictException ex) {
        super((AbstractAggregateException)ex);
        this.sid = ex.getShortId();
        this.expected = ex.getExpected();
        this.actual = ex.getActual();
    }

    @JsonIgnore
    public String getDataElement() {
        return "aggregate-version-conflict-exception";
    }

    @JsonIgnore
    public String getShortId() {
        return this.sid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.actual;
        result = 31 * result + (this.getAggregateId() == null ? 0 : this.getAggregateId().hashCode());
        result = 31 * result + (this.getAggregateType() == null ? 0 : this.getAggregateType().hashCode());
        result = 31 * result + this.expected;
        result = 31 * result + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateVersionConflictExceptionData other = (AggregateVersionConflictExceptionData)obj;
        if (this.actual != other.actual) {
            return false;
        }
        if (this.getAggregateId() == null ? other.getAggregateId() != null : !this.getAggregateId().equals(other.getAggregateId())) {
            return false;
        }
        if (this.getAggregateType() == null ? other.getAggregateType() != null : !this.getAggregateType().equals(other.getAggregateType())) {
            return false;
        }
        if (this.expected != other.expected) {
            return false;
        }
        if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    public String toString() {
        return "AggregateVersionConflictExceptionData [getMessage()=" + this.getMessage() + ", sid=" + this.sid + ", getAggregateType()=" + this.getAggregateType() + ", getAggregateId()=" + this.getAggregateId() + ", expected=" + this.expected + ", actual=" + this.actual + "]";
    }

    public AggregateVersionConflictException toException() {
        return new AggregateVersionConflictException(this.getAggregateType(), this.getAggregateId(), this.expected, this.actual);
    }
}

