/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import io.github.threetenjaxb.core.ZonedDateTimeXmlAdapter;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTypeAdapter;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.ZonedDateTime;
import org.fuin.ddd4j.ddd.Event;
import org.fuin.ddd4j.ddd.EventId;
import org.fuin.ddd4j.ddd.EventIdConverter;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;

public abstract class AbstractEvent
implements Event {
    private static final long serialVersionUID = 1000L;
    @NotNull(message="event-id must not be null")
    @JsonbTypeAdapter(value=EventIdConverter.class)
    @JsonbProperty(value="event-id")
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="event-id")
    private @NotNull(message="event-id must not be null") EventId eventId = new EventId();
    @Label(value="Timestamp")
    @ShortLabel(value="Time")
    @Tooltip(value="Date/Time the event was created")
    @Prompt(value="2016-12-31T23:59:59+02:00")
    @NotNull(message="event-timestamp must not be null")
    @JsonbProperty(value="event-timestamp")
    @XmlJavaTypeAdapter(value=ZonedDateTimeXmlAdapter.class)
    @XmlElement(name="event-timestamp")
    private @NotNull(message="event-timestamp must not be null") ZonedDateTime eventTimestamp = ZonedDateTime.now();
    @Label(value="Correlation Identifier")
    @ShortLabel(value="CorrID")
    @Tooltip(value="Event this one correlates to")
    @Nullable
    @JsonbTypeAdapter(value=EventIdConverter.class)
    @JsonbProperty(value="correlation-id")
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="correlation-id")
    private EventId correlationId;
    @Label(value="Causation Identifier")
    @ShortLabel(value="CauseID")
    @Tooltip(value="Event that caused this one")
    @Nullable
    @JsonbTypeAdapter(value=EventIdConverter.class)
    @JsonbProperty(value="causation-id")
    @XmlJavaTypeAdapter(value=EventIdConverter.class)
    @XmlElement(name="causation-id")
    private EventId causationId;

    public AbstractEvent() {
        this(null, null);
    }

    public AbstractEvent(@NotNull Event respondTo) {
        this(respondTo.getCorrelationId(), respondTo.getEventId());
    }

    public AbstractEvent(@Nullable EventId correlationId, @Nullable EventId causationId) {
        this.correlationId = correlationId;
        this.causationId = causationId;
    }

    @Override
    public final EventId getEventId() {
        return this.eventId;
    }

    @Override
    public final ZonedDateTime getEventTimestamp() {
        return this.eventTimestamp;
    }

    @Override
    public final EventId getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public final EventId getCausationId() {
        return this.causationId;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEvent other = (AbstractEvent)obj;
        return !(this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId));
    }

    protected static abstract class Builder<TYPE extends AbstractEvent, BUILDER extends Builder<TYPE, BUILDER>> {
        private AbstractEvent delegate;

        public Builder(TYPE delegate) {
            this.delegate = delegate;
        }

        public final BUILDER eventId(@NotNull EventId eventId) {
            Contract.requireArgNotNull((String)"eventId", (Object)eventId);
            this.delegate.eventId = eventId;
            return (BUILDER)this;
        }

        public final BUILDER timestamp(@NotNull ZonedDateTime eventTimestamp) {
            Contract.requireArgNotNull((String)"eventTimestamp", (Object)eventTimestamp);
            this.delegate.eventTimestamp = eventTimestamp;
            return (BUILDER)this;
        }

        public final BUILDER correlationId(EventId correlationId) {
            this.delegate.correlationId = correlationId;
            return (BUILDER)this;
        }

        public final BUILDER causationId(EventId causationId) {
            this.delegate.causationId = causationId;
            return (BUILDER)this;
        }

        public final BUILDER causingEvent(Event event) {
            this.delegate.causationId = event.getEventId();
            this.delegate.correlationId = event.getCausationId();
            return (BUILDER)this;
        }

        protected final void ensureBuildableAbstractEvent() {
            this.ensureNotNull("eventId", this.delegate.eventId);
            this.ensureNotNull("timestamp", this.delegate.eventTimestamp);
        }

        protected final void resetAbstractEvent(TYPE delegate) {
            this.delegate = delegate;
        }

        protected final TYPE delegate() {
            return (TYPE)this.delegate;
        }

        protected final void ensureNotNull(String name, Object value) {
            if (value == null) {
                throw new RuntimeException("The value of '" + name + "' has not been set");
            }
        }
    }
}

