/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.common.Contract;

@ThreadSafe
public final class MethodExecutor {
    public final <T> T invokeDeclaredAnnotatedMethod(@NotNull Object obj, @NotNull Class<? extends Annotation> annotationType, Class<?>[] argumentTypes, Object[] arguments) {
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Contract.requireArgNotNull((String)"annotationType", annotationType);
        this.requireValid(argumentTypes, arguments);
        Method method = this.findDeclaredAnnotatedMethod(obj, annotationType, argumentTypes);
        if (method == null) {
            throw new IllegalArgumentException("Cannot find a method annotated with '" + annotationType.getSimpleName() + "' and arguments '" + Arrays.asList(argumentTypes) + "' in class '" + obj.getClass().getName() + "'");
        }
        return this.invoke(method, obj, arguments);
    }

    public final Method findDeclaredAnnotatedMethod(@NotNull Object obj, @NotNull Class<? extends Annotation> annotationType, Class<?> ... expectedArgumentTypes) {
        Method[] methods;
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Contract.requireArgNotNull((String)"annotationType", annotationType);
        for (Method method : methods = obj.getClass().getDeclaredMethods()) {
            Class<?>[] types;
            if (method.getAnnotation(annotationType) == null || !this.same(expectedArgumentTypes, types = method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public final <T> T invoke(@NotNull Method method, @NotNull Object target, Object ... args) {
        Contract.requireArgNotNull((String)"method", (Object)method);
        Contract.requireArgNotNull((String)"target", (Object)target);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (T)method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(this.createInvokeErrMsg(target, method, args), ex);
        }
    }

    private String createInvokeErrMsg(Object target, Method method, Object ... args) {
        if (args == null || args.length == 0) {
            return "Failed to call method '" + method + "' on '" + target.getClass().getSimpleName();
        }
        return "Failed to call method '" + method + "' on '" + target.getClass().getSimpleName() + "' with arguments: " + Arrays.asList(args);
    }

    public final boolean same(Class<?>[] expected, Class<?>[] actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[0] == actual[i]) continue;
            return false;
        }
        return true;
    }

    private void requireValid(Class<?>[] argumentTypes, Object[] arguments) {
        if (argumentTypes == null && arguments != null) {
            throw new IllegalArgumentException("Argument type array is null, but arguments array is not: " + Arrays.asList(arguments));
        }
        if (arguments == null && argumentTypes != null) {
            throw new IllegalArgumentException("Arguments array is null, but argument types array is not: " + Arrays.asList(argumentTypes));
        }
        if (argumentTypes != null && arguments != null && argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Types and arguments have different length: Types=" + Arrays.asList(argumentTypes) + ", Args=" + Arrays.asList(arguments));
        }
    }
}

