/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.lib.autodoc.facade;

import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.core.utils.NamespaceInfo;
import org.xmlet.xsdparser.xsdelements.XsdElement;

public class XsdParserFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XsdParserFacade.class);

    public AutodocModel parse(String filePath) throws ConfigException {
        return (AutodocModel)ConfigException.getWithMessage(() -> {
            XsdParser xsdParser = new XsdParser(filePath);
            AutodocModel autodocModel = new AutodocModel(xsdParser);
            xsdParser.getResultXsdElements().forEach(currentElement -> {
                log.debug("current element {} -> {}", (Object)currentElement.getName(), (Object)currentElement.getType());
                autodocModel.addElement((XsdElement)currentElement);
            });
            xsdParser.getResultXsdSchemas().forEach(currentSchema -> {
                log.debug("current schema {} -> {}", (Object)currentSchema.getTargetNamespace(), (Object)currentSchema.getNamespaces());
                currentSchema.getNamespaces().entrySet().forEach(e -> log.debug("namespace : {} : {}", e.getKey(), (Object)((NamespaceInfo)e.getValue()).getName()));
                currentSchema.getChildrenComplexTypes().forEach(autodocModel::addType);
                currentSchema.getChildrenSimpleTypes().forEach(autodocModel::addSimpleType);
            });
            return autodocModel;
        }, (String)"Error parsing xsd");
    }
}

