/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.lib.autodoc.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.lang.helpers.reflect.MethodHelper;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocElement;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocModel;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocUtils;
import org.fugerit.java.doc.lib.simpletable.SimpleTableFacade;
import org.fugerit.java.doc.lib.simpletable.SimpleTableHelper;
import org.fugerit.java.doc.lib.simpletable.model.SimpleTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdBuiltInDataType;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdSequence;

public class AutodocModelToSinpleTableFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutodocModelToSinpleTableFacade.class);

    private void handleOccurs(StringBuilder builder, XsdAbstractElement xsdObject) {
        SafeFunction.apply(() -> {
            Integer minOccurs = (Integer)MethodHelper.invokeGetter((Object)xsdObject, (String)"minOccurs");
            String maxOccurs = (String)MethodHelper.invokeGetter((Object)xsdObject, (String)"maxOccurs");
            if (minOccurs == null) {
                minOccurs = 1;
            }
            if (maxOccurs == null) {
                maxOccurs = "1";
            }
            builder.append("[");
            builder.append(minOccurs);
            builder.append("-");
            builder.append(maxOccurs);
            builder.append("]");
        });
    }

    private String handleElement(XsdElement xsdObject) {
        StringBuilder builder = new StringBuilder();
        builder.append(xsdObject.getRawName());
        SafeFunction.apply(() -> {
            Integer minOccurs = (Integer)MethodHelper.invokeGetter((Object)xsdObject, (String)"minOccurs");
            String maxOccurs = (String)MethodHelper.invokeGetter((Object)xsdObject, (String)"maxOccurs");
            if (minOccurs != null || maxOccurs != null) {
                if (minOccurs == null) {
                    minOccurs = 1;
                }
                if (maxOccurs == null) {
                    maxOccurs = "1";
                }
                if (minOccurs != 1 || !maxOccurs.equals("1")) {
                    builder.append("[");
                    builder.append(minOccurs);
                    builder.append("-");
                    builder.append(maxOccurs);
                    builder.append("]");
                }
            }
        });
        return builder.toString();
    }

    private String handleChoiceStream(Stream<XsdChoice> stream, String separator) {
        String res = null;
        try {
            List list = stream.map(current -> {
                StringBuilder temp = new StringBuilder();
                this.handleChoice(temp, (XsdChoice)current);
                return temp.toString();
            }).collect(Collectors.toList());
            res = StringUtils.concat((String)separator, list);
        }
        catch (NullPointerException npe) {
            log.warn("npe " + npe);
        }
        return res;
    }

    private String handleSequenceStream(Stream<XsdSequence> stream, String separator) {
        String res = null;
        try {
            List list = stream.map(current -> {
                StringBuilder temp = new StringBuilder();
                this.handleSequence(temp, (XsdSequence)current);
                return temp.toString();
            }).collect(Collectors.toList());
            res = StringUtils.concat((String)separator, list);
        }
        catch (NullPointerException npe) {
            log.warn("npe " + npe);
        }
        return res;
    }

    private void addIfNotEmpty(String s, List<String> list) {
        if (StringUtils.isNotEmpty((String)s)) {
            list.add(s);
        }
    }

    private void handleSequence(StringBuilder builder, XsdSequence xsdObject) {
        String separator = " , ";
        if (xsdObject != null) {
            builder.append("(");
            ArrayList<String> list = new ArrayList<String>();
            this.addIfNotEmpty(StringUtils.concat((String)separator, (Collection)xsdObject.getChildrenElements().map(this::handleElement).collect(Collectors.toList())), list);
            this.addIfNotEmpty(this.handleChoiceStream(xsdObject.getChildrenChoices(), separator), list);
            this.addIfNotEmpty(this.handleSequenceStream(xsdObject.getChildrenSequences(), separator), list);
            builder.append(StringUtils.concat((String)separator, list));
            builder.append(")");
            this.handleOccurs(builder, (XsdAbstractElement)xsdObject);
        }
    }

    private void handleChoice(StringBuilder builder, XsdChoice xsdObject) {
        String separator = " | ";
        if (xsdObject != null) {
            builder.append("(");
            ArrayList<String> list = new ArrayList<String>();
            this.addIfNotEmpty(StringUtils.concat((String)separator, (Collection)xsdObject.getChildrenElements().map(this::handleElement).collect(Collectors.toList())), list);
            this.addIfNotEmpty(this.handleChoiceStream(xsdObject.getChildrenChoices(), separator), list);
            this.addIfNotEmpty(this.handleSequenceStream(xsdObject.getChildrenSequences(), separator), list);
            builder.append(StringUtils.concat((String)separator, list));
            builder.append(")");
            this.handleOccurs(builder, (XsdAbstractElement)xsdObject);
        }
    }

    private void handleComplexType(StringBuilder builder, XsdComplexType complexType) {
        try {
            this.handleSequence(builder, complexType.getChildAsSequence());
        }
        catch (NullPointerException npe) {
            log.warn("npe 1 " + npe + " -> " + complexType.getRawName());
        }
        try {
            this.handleChoice(builder, complexType.getChildAsChoice());
        }
        catch (NullPointerException npe) {
            log.warn("npe 2 " + npe + " -> " + complexType.getRawName());
        }
    }

    private String handleAttributeType(XsdAttribute xsdAttribute) {
        String type = xsdAttribute.getType();
        if (type.startsWith("xsd:")) {
            type = type.replace("xsd:", "");
        }
        if (type.startsWith("doc:")) {
            type = type.replace("doc:", "");
        }
        return type;
    }

    private void iterateElements(SimpleTableHelper helper, SimpleTable simpleTable, AutodocModel autodocModel) {
        for (AutodocElement element : autodocModel.getElements()) {
            XsdBuiltInDataType builtInDataType;
            XsdElement xsdElement = element.getXsdElement();
            String name = xsdElement.getRawName();
            String description = AutodocUtils.annotationAsSingleStringHelper(xsdElement.getAnnotation());
            StringBuilder children = new StringBuilder();
            XsdComplexType complexType = element.getComplexType();
            if (complexType != null) {
                this.handleComplexType(children, complexType);
            }
            if ((builtInDataType = xsdElement.getTypeAsBuiltInDataType()) != null) {
                children.append(builtInDataType.toString());
            }
            simpleTable.addRow(helper.newNormalRow(new String[]{name, description, children.toString()}));
        }
    }

    private void iterateAttributes(SimpleTableHelper helper, SimpleTable simpleTable, AutodocModel autodocModel) {
        for (AutodocElement element : autodocModel.getElements()) {
            XsdElement xsdElement = element.getXsdElement();
            XsdComplexType complexType = element.getComplexType();
            if (complexType == null) continue;
            try {
                List listAtts = complexType.getAllXsdAttributes().collect(Collectors.toList());
                if (listAtts.isEmpty()) continue;
                simpleTable.addRow(helper.newHeaderRow(new String[]{"Attributes for : " + xsdElement.getRawName(), "Description", "Type"}));
                for (XsdAttribute xsdAttribute : listAtts) {
                    simpleTable.addRow(helper.newNormalRow(new String[]{xsdAttribute.getRawName(), AutodocUtils.annotationAsSingleStringHelper(xsdAttribute.getAnnotation()), this.handleAttributeType(xsdAttribute)}));
                }
            }
            catch (NullPointerException npe) {
                log.warn("Exception on attributes {}", (Object)npe.toString());
            }
        }
    }

    public SimpleTable toSimpleTable(AutodocModel autodocModel) {
        SimpleTableHelper helper = SimpleTableFacade.newHelper().withDefaultBorderWidth(1);
        SimpleTable simpleTable = helper.newTable(new Integer[]{20, 40, 40});
        simpleTable.addRow(helper.newHeaderRow(new String[]{"Element", "Description", "Children"}));
        this.iterateElements(helper, simpleTable, autodocModel);
        this.iterateAttributes(helper, simpleTable, autodocModel);
        return simpleTable;
    }
}

