/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.lib.autodoc;

import java.io.OutputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import lombok.Generated;
import org.fugerit.java.core.util.ObjectUtils;
import org.fugerit.java.core.util.PropsIO;
import org.fugerit.java.core.util.filterchain.MiniFilterChain;
import org.fugerit.java.core.util.filterchain.MiniFilterContext;
import org.fugerit.java.core.util.filterchain.MiniFilterData;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.facade.DocFacade;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.process.DocProcessContext;
import org.fugerit.java.doc.base.process.DocProcessData;
import org.fugerit.java.doc.freemarker.html.FreeMarkerHtmlTypeHandler;
import org.fugerit.java.doc.freemarker.process.FreemarkerDocProcessConfig;
import org.fugerit.java.doc.freemarker.process.FreemarkerDocProcessConfigFacade;
import org.fugerit.java.doc.lib.autodoc.detail.AutodocDetailModel;
import org.fugerit.java.doc.lib.autodoc.meta.AutodocMetaModel;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutodocDocConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutodocDocConfig.class);
    private FreemarkerDocProcessConfig config;
    private static final AutodocDocConfig INSTANCE = new AutodocDocConfig(FreemarkerDocProcessConfigFacade.loadConfigSafe((String)"cl://fj_doc_lib_autodoc/fm-doc-process-config-autodoc.xml"));
    public static final String CHAIN_ID_AUTODOC = "autodoc";
    public static final String CHAIN_ID_AUTODOC_SCHEMA = "autodoc_schema";
    public static final String CHAIN_ID_AUTODOC_DETAIL = "autodoc_detail";
    public static final String CHAIN_ID_AUTODOC_META = "autodoc_meta";
    public static final String ATT_PARAMS = "params";
    public static final String ATT_LABELS = "labels";
    public static final String PARAM_USE_LANGUAGE = "use-language";
    public static final String PARAM_USE_LANGUAGE_EN = Locale.ENGLISH.getLanguage();
    public static final String PARAM_USE_LANGUAGE_IT = Locale.ITALIAN.getLanguage();
    public static final String PARAM_USE_LANGUAGE_DEFAULT = PARAM_USE_LANGUAGE_EN;

    private AutodocDocConfig(FreemarkerDocProcessConfig config) {
        this.config = config;
    }

    public static AutodocDocConfig getInstance() {
        return INSTANCE;
    }

    public static AutodocDocConfig newConfig() {
        return AutodocDocConfig.getInstance();
    }

    public FreemarkerDocProcessConfig getConfig() {
        return this.config;
    }

    private void process(String chainId, DocProcessContext context, DocProcessData data) throws Exception {
        MiniFilterChain chain = this.getConfig().getChainCache(chainId);
        chain.apply((MiniFilterContext)context, (MiniFilterData)data);
    }

    public void processAutodoc(AutodocModel autodocModel, DocTypeHandler handler, OutputStream os) throws DocException {
        DocException.applyWithMessage(() -> {
            DocProcessData data = new DocProcessData();
            DocProcessContext context = DocProcessContext.newContext((String)"autodocModel", (Object)autodocModel);
            this.process(CHAIN_ID_AUTODOC, context, data);
            DocBase docBase = DocFacade.parse((Reader)data.getCurrentXmlReader());
            DocInput docInput = DocInput.newInput((String)handler.getType(), (DocBase)docBase);
            DocOutput docOutput = DocOutput.newOutput((OutputStream)os);
            handler.handle(docInput, docOutput);
        }, (String)"Autodoc generation error");
    }

    public void processAutodocHtmlDefault(AutodocModel autodocModel, OutputStream os) throws DocException {
        this.processAutodoc(autodocModel, FreeMarkerHtmlTypeHandler.HANDLER, os);
    }

    public void processAutodocSchema(AutodocModel autodocModel, DocTypeHandler handler, OutputStream os, Properties params) throws DocException {
        DocException.applyWithMessage(() -> {
            DocProcessData data = new DocProcessData();
            DocProcessContext context = DocProcessContext.newContext((String)"autodocModel", (Object)autodocModel);
            context.setAttribute(ATT_PARAMS, ObjectUtils.objectWithDefault((Object)params, (Object)new Properties()));
            String languageTag = params.getProperty(PARAM_USE_LANGUAGE, PARAM_USE_LANGUAGE_EN);
            ResourceBundle labelsBundle = ResourceBundle.getBundle("fj_doc_lib_autodoc.i18n.label", Locale.forLanguageTag(languageTag));
            Properties labels = PropsIO.loadFromBundle((ResourceBundle)labelsBundle);
            log.info("labels {}", (Object)labels);
            context.setAttribute(ATT_LABELS, (Object)labels);
            this.process(CHAIN_ID_AUTODOC_SCHEMA, context, data);
            DocBase docBase = DocFacade.parse((Reader)data.getCurrentXmlReader());
            DocInput docInput = DocInput.newInput((String)handler.getType(), (DocBase)docBase);
            DocOutput docOutput = DocOutput.newOutput((OutputStream)os);
            handler.handle(docInput, docOutput);
        }, (String)"Autodoc generation error");
    }

    public void processAutodocSchemaHtmlDefault(AutodocModel autodocModel, OutputStream os, Properties params) throws DocException {
        this.processAutodocSchema(autodocModel, FreeMarkerHtmlTypeHandler.HANDLER_UTF8, os, params);
    }

    public void processAutodocDetail(AutodocDetailModel autoDetailModel, DocTypeHandler handler, OutputStream os) throws DocException {
        DocException.applyWithMessage(() -> {
            DocProcessData data = new DocProcessData();
            DocProcessContext context = DocProcessContext.newContext((String)"autodocDetailModel", (Object)autoDetailModel);
            this.process(CHAIN_ID_AUTODOC_DETAIL, context, data);
            DocBase docBase = DocFacade.parse((Reader)data.getCurrentXmlReader());
            DocInput docInput = DocInput.newInput((String)handler.getType(), (DocBase)docBase);
            DocOutput docOutput = DocOutput.newOutput((OutputStream)os);
            handler.handle(docInput, docOutput);
        }, (String)"Autodoc detail generation error");
    }

    public void processAutodocDetailHtmlDefault(AutodocDetailModel autoDetailModel, OutputStream os) throws DocException {
        this.processAutodocDetail(autoDetailModel, FreeMarkerHtmlTypeHandler.HANDLER, os);
    }

    public void processAutodocMeta(AutodocMetaModel autodocMetaModel, DocTypeHandler handler, OutputStream os) throws DocException {
        DocException.applyWithMessage(() -> {
            DocProcessData data = new DocProcessData();
            DocProcessContext context = DocProcessContext.newContext((String)"autodocMetaModel", (Object)autodocMetaModel);
            this.process(CHAIN_ID_AUTODOC_META, context, data);
            DocBase docBase = DocFacade.parse((Reader)data.getCurrentXmlReader());
            DocInput docInput = DocInput.newInput((String)handler.getType(), (DocBase)docBase);
            DocOutput docOutput = DocOutput.newOutput((OutputStream)os);
            handler.handle(docInput, docOutput);
        }, (String)"Autodoc meta generation error");
    }
}

