/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.NotImplementedException;
import org.frankframework.management.bus.BusException;

public class JacksonUtils {
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();

    public static String convertToJson(Object payload) {
        try {
            return MAPPER.writeValueAsString(payload);
        }
        catch (JacksonException e) {
            throw new BusException("unable to convert response to JSON", e);
        }
    }

    public static <T> T convertToDTO(Object payload, Class<T> dto) {
        try {
            if (payload instanceof String) {
                String string = (String)payload;
                return (T)MAPPER.readValue(string, dto);
            }
            if (payload instanceof byte[]) {
                byte[] bytes = (byte[])payload;
                return (T)MAPPER.readValue(bytes, dto);
            }
            if (payload instanceof InputStream) {
                InputStream stream = (InputStream)payload;
                return (T)MAPPER.readValue(stream, dto);
            }
            throw new NotImplementedException("unhandled payload type [" + String.valueOf(payload.getClass()) + "]");
        }
        catch (JacksonException e) {
            throw new BusException("unable to convert payload", e);
        }
        catch (IOException e) {
            throw new BusException("unable to parse payload", e);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }
}

