/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import com.nimbusds.jose.jwk.source.JWKSetSource;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Supplier;
import org.frankframework.management.security.JwtAuthenticationToken;
import org.frankframework.management.security.JwtKeyGenerator;
import org.springframework.security.core.Authentication;

public class JwtVerifier
extends DefaultJWTProcessor<SecurityContext> {
    public JwtVerifier(Supplier<String> supply) {
        this.setJWSKeySelector((JWSKeySelector)new LazyLoadingJwkSource(supply));
    }

    public Authentication verify(String jwt) throws IOException {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = this.process(jwt, null);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            throw new IOException("unable to parse JWT", e);
        }
        try {
            return new JwtAuthenticationToken(claimsSet, jwt);
        }
        catch (ParseException e) {
            throw new IOException("unable to create AuthenticationToken", e);
        }
    }

    private static class LazyLoadingJwkSource
    extends JWSVerificationKeySelector<SecurityContext> {
        public LazyLoadingJwkSource(Supplier<String> supply) {
            super(JwtKeyGenerator.JWT_DEFAULT_SIGNING_ALGORITHM, LazyLoadingJwkSource.createKeySource(supply));
        }

        private static JWKSource<SecurityContext> createKeySource(Supplier<String> supply) {
            return JWKSourceBuilder.create((JWKSetSource)new LazyLoadingJwkSetSource(supply)).cacheForever().build();
        }
    }

    private static class LazyLoadingJwkSetSource
    implements JWKSetSource<SecurityContext> {
        private final Supplier<String> supply;

        public LazyLoadingJwkSetSource(Supplier<String> supply) {
            this.supply = supply;
        }

        public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, SecurityContext context) throws KeySourceException {
            try {
                String jwks = this.supply.get();
                if (jwks == null) {
                    throw new KeySourceException("no jwks found");
                }
                return JWKSet.parse((String)jwks);
            }
            catch (ParseException e) {
                throw new KeySourceException("parse exception", (Throwable)e);
            }
        }

        public void close() throws IOException {
        }
    }
}

