/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.management.security.JwtAuthenticationToken;
import org.frankframework.management.security.JwtKeyGenerator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

public class JwtSecurityFilter
implements Filter,
InitializingBean {
    private static final String JWT_TOKEN_CONTEXT_KEY = "JWT_TOKEN_CONTEXT_KEY";
    private ConfigurableJWTProcessor<com.nimbusds.jose.proc.SecurityContext> jwtProcessor;
    private final Logger log = LogManager.getLogger(JwtSecurityFilter.class);
    @Value(value="${management.gateway.http.jwks.endpoint}")
    private String jwksEndpoint;
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            SecurityContext newContext = this.securityContextHolderStrategy.createEmptyContext();
            newContext.setAuthentication(this.getAuthenticationToken((HttpServletRequest)request));
            this.securityContextHolderStrategy.setContext(newContext);
        }
        catch (IOException e) {
            this.securityContextHolderStrategy.clearContext();
            this.log.warn("failed to process authentication request", (Throwable)e);
            throw e;
        }
        chain.doFilter(request, response);
    }

    private Authentication getAuthenticationToken(HttpServletRequest req) throws IOException {
        String jwtHeader = req.getHeader("Authentication");
        if (StringUtils.isEmpty((CharSequence)jwtHeader) || !jwtHeader.contains("Bearer")) {
            this.securityContextHolderStrategy.clearContext();
            this.log.debug("Failed to process authentication request");
            throw new IOException("no (valid) JWT provided");
        }
        String jwt = jwtHeader.substring(7);
        HttpSession session = req.getSession(true);
        JwtAuthenticationToken storedJWT = (JwtAuthenticationToken)((Object)session.getAttribute(JWT_TOKEN_CONTEXT_KEY));
        if (storedJWT != null && storedJWT.verifyJWT(jwt)) {
            this.log.debug("using stored authentication token [{}]", (Object)storedJWT);
            return storedJWT;
        }
        Authentication newToken = this.createAuthenticationToken(jwt);
        this.log.debug("created new authentication token [{}]", (Object)newToken);
        session.setAttribute(JWT_TOKEN_CONTEXT_KEY, (Object)newToken);
        return newToken;
    }

    private Authentication createAuthenticationToken(String jwt) throws IOException {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = this.jwtProcessor.process(jwt, null);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            throw new IOException("unable to parse JWT", e);
        }
        try {
            return new JwtAuthenticationToken(claimsSet, jwt);
        }
        catch (ParseException e) {
            throw new IOException("unable to create AuthenticationToken", e);
        }
    }

    public void destroy() {
        this.jwtProcessor = null;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.jwksEndpoint)) {
            throw new IllegalStateException("no JWKS endpoint specified");
        }
        URL url = new URL(this.jwksEndpoint);
        JWKSource keySource = JWKSourceBuilder.create((URL)url).cacheForever().build();
        this.jwtProcessor = new DefaultJWTProcessor();
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JwtKeyGenerator.JWT_DEFAULT_SIGNING_ALGORITHM, keySource);
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
    }

    @Generated
    public void setJwksEndpoint(String jwksEndpoint) {
        this.jwksEndpoint = jwksEndpoint;
    }
}

