/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import jakarta.annotation.Nonnull;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.util.Environment;
import org.frankframework.util.UUIDUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class JwtKeyGenerator
implements InitializingBean {
    public static final Curve JWT_DEFAULT_CURVE = Curve.P_384;
    public static final JWSAlgorithm JWT_DEFAULT_SIGNING_ALGORITHM = JWSAlgorithm.ES384;
    private final Logger log = LogManager.getLogger(JwtKeyGenerator.class);
    private JWSSigner signer;
    private String publicJwkSet;
    private JWSHeader jwtHeader;

    public void afterPropertiesSet() {
        try {
            ECKey key = (ECKey)new ECKeyGenerator(JWT_DEFAULT_CURVE).keyIDFromThumbprint(true).generate();
            String version = Environment.getModuleVersion((String)"iaf-management-gateway");
            this.log.info("initializing JWT KeyGenerator version [{}]", (Object)version);
            this.generateJWSHeader(key, version);
            ECPrivateKey privateKey = key.toECPrivateKey();
            this.signer = new ECDSASigner((PrivateKey)privateKey, JWT_DEFAULT_CURVE);
            JWKSet set = new JWKSet((JWK)key.toPublicJWK());
            this.publicJwkSet = set.toString();
        }
        catch (JOSEException e) {
            throw new IllegalStateException("unable to generate JWT header", e);
        }
    }

    private void generateJWSHeader(ECKey key, String version) {
        this.jwtHeader = new JWSHeader.Builder(JWT_DEFAULT_SIGNING_ALGORITHM).type(JOSEObjectType.JWT).customParam("version", (Object)version).keyID(key.getKeyID()).build();
    }

    @Nonnull
    public String create() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationServiceException("no Authentication object found in SecurityContext");
        }
        JWTClaimsSet claims = this.createClaimsSet(authentication);
        return this.createJwtToken(claims);
    }

    @Nonnull
    private JWTClaimsSet createClaimsSet(Authentication authentication) {
        try {
            return new JWTClaimsSet.Builder().subject(this.getPrincipalName(authentication)).expirationTime(Date.from(Instant.now().plusSeconds(120L))).issueTime(Date.from(Instant.now())).jwtID(UUIDUtil.createRandomUUID()).claim("scope", this.mapAuthorities(authentication)).build();
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("unable to generate JWT ClaimsSet", (Throwable)e);
        }
    }

    private String getPrincipalName(Authentication authentication) {
        if (authentication.getPrincipal() instanceof OidcUser) {
            return ((OidcUser)authentication.getPrincipal()).getGivenName();
        }
        return authentication.getName();
    }

    private List<String> mapAuthorities(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    @Nonnull
    private String createJwtToken(@Nonnull JWTClaimsSet claims) {
        SignedJWT signedJWT = new SignedJWT(this.jwtHeader, claims);
        try {
            signedJWT.sign(this.signer);
        }
        catch (JOSEException e) {
            throw new AuthenticationServiceException("unable to sign JWT using [" + String.valueOf(this.signer) + "]", (Throwable)e);
        }
        String jwt = signedJWT.serialize();
        this.log.trace("generated JWT token [{}]", (Object)jwt);
        return jwt;
    }

    @Generated
    public String getPublicJwkSet() {
        return this.publicJwkSet;
    }
}

