/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.security;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String principal;
    private final String key;
    private final String rawJwt;
    private final Date expiresAt;

    public JwtAuthenticationToken(JWTClaimsSet claimsSet, String rawJwt) throws ParseException {
        super(JwtAuthenticationToken.createAuthorityList(claimsSet));
        this.key = claimsSet.getJWTID();
        this.principal = claimsSet.getSubject();
        this.expiresAt = claimsSet.getExpirationTime();
        this.rawJwt = rawJwt;
    }

    public boolean isAuthenticated() {
        return new Date().before(this.expiresAt);
    }

    private static List<GrantedAuthority> createAuthorityList(JWTClaimsSet claimsSet) throws ParseException {
        List authorities = claimsSet.getStringListClaim("scope");
        if (authorities != null) {
            return authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        }
        return AuthorityUtils.NO_AUTHORITIES;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken other = (JwtAuthenticationToken)((Object)obj);
            return this.key == other.key;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean verifyJWT(String jwt) {
        return this.rawJwt.equals(jwt);
    }
}

