/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.util.CloseUtils;

public class SerializableInputStream
extends InputStream
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int BUFFERSIZE = 20480;
    private static final Logger LOG = LogManager.getLogger(SerializableInputStream.class);
    private final transient Path tmpFile;
    private transient InputStream delegate;

    public SerializableInputStream() {
        LOG.trace("creating new SerializableInputStream from deserialization");
        String tmpdir = System.getProperty("java.io.tmpdir");
        Path dir = Path.of(tmpdir, new String[0]);
        Path tmpDir = dir.resolve("frank-management-gateway");
        try {
            if (!Files.exists(tmpDir, new LinkOption[0])) {
                Files.createDirectory(tmpDir, new FileAttribute[0]);
            }
            this.tmpFile = Files.createTempFile(tmpDir, "msg", ".dat", new FileAttribute[0]);
            LOG.trace("determined temporary file location [{}]", (Object)this.tmpFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create temp file to de-serialize stream", e);
        }
    }

    public SerializableInputStream(InputStream in) {
        LOG.trace("creating new SerializableInputStream with delegate");
        this.delegate = in;
        this.tmpFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        LOG.trace("Writing delegate to ObjectOutput with buffersize [{}]", (Object)20480);
        try (InputStream is = this.delegate;){
            int bytesRead;
            int overallBytes = 0;
            byte[] buffer = new byte[20480];
            while ((bytesRead = is.read(buffer, 0, 20480)) > 0) {
                LOG.trace("wrote [{}] bytes to ObjectOutput", (Object)bytesRead);
                out.writeInt(bytesRead);
                out.write(buffer, 0, bytesRead);
                overallBytes += bytesRead;
            }
            out.writeInt(0);
            LOG.trace("finished serializing stream, total bytes written [{}]", (Object)overallBytes);
        }
        finally {
            this.delegate = null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try (OutputStream fos = Files.newOutputStream(this.tmpFile, new OpenOption[0]);){
            this.copyStream(in, fos);
        }
        this.delegate = Files.newInputStream(this.tmpFile, new OpenOption[0]);
    }

    private void copyStream(ObjectInput in, OutputStream fos) throws IOException {
        int overallBytes = 0;
        int toRead = in.readInt();
        overallBytes += toRead;
        byte[] buffer = null;
        while (toRead > 0) {
            LOG.trace("reading up to [{}] bytes from ObjectInput", (Object)toRead);
            buffer = this.allocateBuffer(toRead, buffer);
            int readLocally = in.read(buffer, 0, toRead);
            LOG.trace("read [{}] bytes from stream and stored them in the buffer", (Object)readLocally);
            fos.write(buffer, 0, readLocally);
            if ((toRead -= readLocally) != 0) continue;
            toRead = in.readInt();
            overallBytes += toRead;
        }
        LOG.trace("finished deserializing stream, total bytes read [{}]", (Object)overallBytes);
    }

    private byte[] allocateBuffer(int size, byte[] buffer) {
        if (buffer != null && buffer.length >= size) {
            return buffer;
        }
        return new byte[size];
    }

    @Override
    public int read() throws IOException {
        this.checkIfDelegateExists();
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkIfDelegateExists();
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkIfDelegateExists();
        return this.delegate.read(b, off, len);
    }

    private void checkIfDelegateExists() throws IOException {
        if (this.delegate == null) {
            throw new IOException("delegate has not been set, unable to read stream");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            CloseUtils.closeSilently((AutoCloseable)this.delegate);
        }
        finally {
            if (this.tmpFile != null) {
                LOG.trace("removing temporary file location [{}]", (Object)this.tmpFile);
                Files.delete(this.tmpFile);
            }
        }
    }
}

