/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import jakarta.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.frankframework.management.bus.OutboundGateway;
import org.frankframework.management.gateway.HttpOutboundHandler;
import org.frankframework.util.SpringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.messaging.Message;

public class HttpOutboundGateway
implements InitializingBean,
ApplicationContextAware,
OutboundGateway {
    private HttpOutboundHandler handler;
    private ApplicationContext applicationContext;
    @Value(value="${management.gateway.http.outbound.endpoint}")
    private String endpoint;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            throw new IllegalStateException("no endpoint specified");
        }
        this.handler = new HttpOutboundHandler(this.endpoint);
        SpringUtils.autowireByType((ApplicationContext)this.applicationContext, (Object)((Object)this.handler));
    }

    @Override
    @Nonnull
    public <I, O> Message<O> sendSyncMessage(Message<I> in) {
        return this.handler.handleRequestMessage(in);
    }

    @Override
    public <I> void sendAsyncMessage(Message<I> in) {
        this.handler.handleRequestMessage(in);
    }

    @Override
    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.outbound_gateway;
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

