/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import jakarta.servlet.Filter;
import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.management.gateway.ErrorMessageConverter;
import org.frankframework.management.gateway.InputStreamHttpMessageConverter;
import org.frankframework.management.security.JwtSecurityFilter;
import org.frankframework.util.SpringUtils;
import org.frankframework.util.StreamUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.HttpRequestHandlerServlet;
import org.springframework.web.filter.RequestContextFilter;

@Order(value=0x7FFFFFFE)
public class HttpInboundGateway
implements WebSecurityConfigurer<WebSecurity>,
ServletContextAware,
IntegrationPattern,
InitializingBean,
ApplicationContextAware,
BeanFactoryAware {
    @Generated
    private static final Logger log = LogManager.getLogger(HttpInboundGateway.class);
    private static final String HTTP_SECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.configuration.HttpSecurityConfiguration.httpSecurity";
    private static final String SERVLET_NAME = "HttpInboundGatewayServlet";
    private static final byte[] NOT_AVAILABLE = "Backend not available".getBytes(StandardCharsets.UTF_8);
    private HttpRequestHandlingMessagingGateway gateway;
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private ServletContext servletContext;
    @Value(value="${management.gateway.http.inbound.path:/iaf/management}")
    private String httpPath;

    public void afterPropertiesSet() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("no ApplicationContext set");
        }
        if (this.gateway == null) {
            this.createGateway();
            this.createGatewayEndpoint();
        }
    }

    private void createGateway() {
        this.gateway = (HttpRequestHandlingMessagingGateway)SpringUtils.createBean((ApplicationContext)this.applicationContext, HttpMessagingGateway.class);
        this.gateway.setRequestChannel(this.getRequestChannel(this.applicationContext));
        this.gateway.setErrorChannel((MessageChannel)this.getErrorChannel(this.applicationContext));
        this.gateway.setMessageConverters(this.getMessageConverters());
        this.gateway.setErrorOnTimeout(false);
        this.gateway.setRequestTimeout(0L);
        this.gateway.setReplyTimeout(0L);
        DefaultHttpHeaderMapper headerMapper = (DefaultHttpHeaderMapper)SpringUtils.createBean((ApplicationContext)this.applicationContext, DefaultHttpHeaderMapper.class);
        headerMapper.setInboundHeaderNames(this.getRequestHeaders());
        headerMapper.setOutboundHeaderNames(new String[]{"meta-*"});
        this.gateway.setHeaderMapper((HeaderMapper)headerMapper);
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)this.beanFactory;
        cbf.registerSingleton(SERVLET_NAME, (Object)this.gateway);
    }

    public void createGatewayEndpoint() {
        HttpRequestHandlerServlet servlet = new HttpRequestHandlerServlet();
        log.info("created management service endpoint [{}]", (Object)this.httpPath);
        this.servletContext.log("enabling management endpoint [" + this.httpPath + "]");
        ServletRegistration.Dynamic serv = this.servletContext.addServlet(SERVLET_NAME, (Servlet)servlet);
        serv.setLoadOnStartup(-1);
        serv.addMapping(new String[]{this.httpPath});
        HttpConstraintElement httpConstraintElement = new HttpConstraintElement(ServletSecurity.TransportGuarantee.NONE, new String[0]);
        serv.setServletSecurity(new ServletSecurityElement(httpConstraintElement));
    }

    private String[] getRequestHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("action");
        headers.add("topic");
        headers.add("target");
        headers.add("meta-*");
        return headers.toArray(new String[0]);
    }

    private MessageChannel getRequestChannel(ApplicationContext applicationContext) {
        return (MessageChannel)applicationContext.getBean("frank-management-bus", MessageChannel.class);
    }

    private SubscribableChannel getErrorChannel(ApplicationContext applicationContext) {
        PublishSubscribeChannel channel = (PublishSubscribeChannel)SpringUtils.createBean((ApplicationContext)applicationContext, PublishSubscribeChannel.class);
        channel.setBeanName("ErrorMessageConvertingChannel");
        ErrorMessageConverter errorConverter = (ErrorMessageConverter)((Object)SpringUtils.createBean((ApplicationContext)applicationContext, ErrorMessageConverter.class));
        if (channel.subscribe((MessageHandler)errorConverter)) {
            log.info("created ErrorMessageConverter [{}]", (Object)errorConverter);
        } else {
            log.info("unable to create ErrorMessageConverter, all errors wil be ingored");
            this.gateway.setErrorOnTimeout(false);
        }
        return channel;
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(StreamUtil.DEFAULT_CHARSET);
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        messageConverters.add((HttpMessageConverter<?>)new InputStreamHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        return messageConverters;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.inbound_gateway;
    }

    public void init(WebSecurity builder) {
    }

    public void configure(WebSecurity webSecurity) {
        SecurityFilterChain chain = this.createSecurityFilterChain();
        SpringUtils.registerSingleton((ApplicationContext)this.applicationContext, (String)"HttpInboundGateway-SecurityFilter", (Object)chain);
        webSecurity.addSecurityFilterChainBuilder(() -> chain);
    }

    private SecurityFilterChain createSecurityFilterChain() {
        HttpSecurity httpSecurityConfigurer = (HttpSecurity)this.applicationContext.getBean(HTTP_SECURITY_BEAN_NAME, HttpSecurity.class);
        return this.configureHttpSecurity(httpSecurityConfigurer);
    }

    private SecurityFilterChain configureHttpSecurity(HttpSecurity http) {
        try {
            http.headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin));
            http.csrf(AbstractHttpConfigurer::disable);
            http.securityMatcher((RequestMatcher)new AntPathRequestMatcher(this.httpPath));
            http.formLogin(AbstractHttpConfigurer::disable);
            http.anonymous(AbstractHttpConfigurer::disable);
            http.logout(AbstractHttpConfigurer::disable);
            http.sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED));
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
            Filter requestDispatcher = (Filter)SpringUtils.createBean((ApplicationContext)this.applicationContext, RequestContextFilter.class);
            http.addFilterAfter(requestDispatcher, AuthorizationFilter.class);
            JwtSecurityFilter securityFilter = (JwtSecurityFilter)SpringUtils.createBean((ApplicationContext)this.applicationContext, JwtSecurityFilter.class);
            http.addFilterBefore((Filter)securityFilter, BasicAuthenticationFilter.class);
            return (SecurityFilterChain)http.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to configure Spring Security", e);
        }
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Generated
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private static class HttpMessagingGateway
    extends HttpRequestHandlingMessagingGateway {
        private HttpMessagingGateway() {
        }

        protected void setStatusCodeIfNeeded(ServerHttpResponse response, HttpEntity<?> httpEntity) {
            response.setStatusCode((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
            try {
                StreamUtils.copy((byte[])NOT_AVAILABLE, (OutputStream)response.getBody());
            }
            catch (IOException e) {
                log.debug("unable to copy servlet response", (Throwable)e);
            }
        }
    }
}

