/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.frankframework.management.gateway.HazelcastConfig;
import org.frankframework.management.gateway.SerializableInputStream;
import org.frankframework.management.security.JwtVerifier;
import org.frankframework.util.SpringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

public class HazelcastInboundGateway
extends MessagingGatewaySupport {
    @Generated
    private static final Logger log = LogManager.getLogger(HazelcastInboundGateway.class);
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private HazelcastInstance hzInstance;
    private final String requestTopicName = "frank_integration_request_topic";
    private ITopic<org.springframework.messaging.Message<?>> requestTopic;
    private JwtVerifier jwtVerifier;
    @Value(value="${instance.name:}")
    private String instanceName;

    protected void onInit() {
        Map<String, String> attributes = Map.of("application", this.instanceName);
        this.hzInstance = HazelcastConfig.newHazelcastInstance(HazelcastConfig.InstanceType.WORKER, attributes);
        SpringUtils.registerSingleton((ApplicationContext)this.getApplicationContext(), (String)"hazelcastInboundInstance", (Object)this.hzInstance);
        this.requestTopic = this.hzInstance.getTopic("frank_integration_request_topic");
        IMap config = this.hzInstance.getMap("frank-configuration");
        this.jwtVerifier = new JwtVerifier(() -> (String)config.get((Object)"jwks"));
        this.setRequestChannel(this.getRequestChannel(this.getApplicationContext()));
        this.setErrorChannel(null);
        super.onInit();
        UUID listenerId = this.requestTopic.addMessageListener(this::handleIncomingMessage);
        log.debug("created message listener [{}] on topic [{}]", (Object)listenerId, (Object)"frank_integration_request_topic");
    }

    private MessageChannel getRequestChannel(ApplicationContext applicationContext) {
        return (MessageChannel)applicationContext.getBean("frank-management-bus", MessageChannel.class);
    }

    private <E extends org.springframework.messaging.Message<?>> void handleIncomingMessage(Message<E> rawMessage) {
        org.springframework.messaging.Message message = (org.springframework.messaging.Message)rawMessage.getMessageObject();
        UUID instanceId = this.hzInstance.getLocalEndpoint().getUuid();
        UUID filterId = (UUID)message.getHeaders().get((Object)"target", UUID.class);
        UUID messageId = message.getHeaders().getId();
        if (filterId != null && !filterId.equals(instanceId)) {
            log.trace("skipping message with id [{}] from member [{}]", new Supplier[]{() -> messageId, () -> rawMessage.getPublishingMember().getUuid()});
            return;
        }
        log.trace("received message with id [{}] from member [{}]", new Supplier[]{() -> messageId, () -> rawMessage.getPublishingMember().getUuid()});
        try (CloseableThreadContext.Instance ctc = CloseableThreadContext.put((String)"messageId", (String)messageId.toString());){
            String tempReplyChannel = (String)message.getHeaders().getReplyChannel();
            log.debug("received message [{}] {} reply-channel", (Object)message, (Object)(tempReplyChannel == null ? "without" : "with"));
            this.processMessage(message, tempReplyChannel);
        }
    }

    private void processMessage(@Nonnull org.springframework.messaging.Message<?> incomingMessage, @Nullable String tempReplyChannel) {
        MessageHeaders headers = incomingMessage.getHeaders();
        try {
            this.propagateAuthenticationContext(headers);
            if (tempReplyChannel == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((MessageHeaders)headers).getId();
                log.trace("processing message id [{}] asynchronous", supplierArray);
                super.send(incomingMessage);
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((MessageHeaders)headers).getId();
                log.trace("processing message id [{}] synchronous", supplierArray);
                org.springframework.messaging.Message response = super.sendAndReceiveMessage(incomingMessage);
                if (response == null) {
                    log.trace("synchronous message did not return a response");
                    return;
                }
                this.handleResponse(response, tempReplyChannel);
            }
        }
        catch (MessageHandlingException e) {
            log.warn("error processing message id [{}]", (Object)headers.getId(), (Object)e.getCause());
        }
        catch (Exception e) {
            log.error("error processing message id [{}]", (Object)headers.getId(), (Object)e);
        }
    }

    private void handleResponse(org.springframework.messaging.Message<?> response, @Nonnull String tempReplyChannel) {
        MessageHeaders headers = response.getHeaders();
        if (response instanceof ErrorMessage) {
            ErrorMessage errMsg = (ErrorMessage)response;
            throw (Throwable)errMsg.getPayload();
        }
        Object object = response.getPayload();
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            response = ((MessageBuilder)MessageBuilder.withPayload((Object)new SerializableInputStream(inputStream)).copyHeaders((Map)headers)).build();
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((MessageHeaders)headers).getId();
        supplierArray[1] = () -> tempReplyChannel;
        log.trace("sending response message id [{}] to reply-channel [{}]", supplierArray);
        IQueue responseQueue = this.hzInstance.getQueue(tempReplyChannel);
        if (!responseQueue.offer((Object)response)) {
            log.error("unable to send response [{}] to reply-channel [{}]", (Object)response, (Object)tempReplyChannel);
        }
    }

    private void propagateAuthenticationContext(@Nonnull MessageHeaders headers) throws IOException {
        Object auth = headers.get((Object)"meta-user");
        Authentication authentication = this.createAuthenticationToken(auth);
        SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
        context.setAuthentication(authentication);
        this.securityContextHolderStrategy.setContext(context);
    }

    private Authentication createAuthenticationToken(Object authenticationObject) throws IOException {
        if (authenticationObject instanceof Authentication) {
            Authentication authentication = (Authentication)authenticationObject;
            return authentication;
        }
        if (authenticationObject instanceof String) {
            String jwt = (String)authenticationObject;
            return this.jwtVerifier.verify(jwt);
        }
        throw new IOException("no authentication object found");
    }
}

