/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.DefaultNodeContext;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.instance.impl.MobyNames;
import com.hazelcast.instance.impl.NodeContext;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.util.Environment;
import org.frankframework.util.PropertyLoader;

public class HazelcastConfig {
    @Generated
    private static final Logger log = LogManager.getLogger(HazelcastConfig.class);
    private static final AtomicInteger FACTORY_ID_GEN = new AtomicInteger();
    public static final String ATTRIBUTE_TYPE_KEY = "type";
    public static final String ATTRIBUTE_NAME_KEY = "name";
    public static final String ATTRIBUTE_APPLICATION_KEY = "application";
    public static final String ATTRIBUTE_VERSION_KEY = "version";
    public static final String REQUEST_TOPIC_NAME = "frank_integration_request_topic";
    public static final String AUTHENTICATION_HEADER_KEY = "meta-user";
    private static final String VERSION = Environment.getModuleVersion((String)"frankframework-management-gateway");
    public static final String FRANK_APPLICATION_CONFIG = "frank-configuration";
    public static final String FRANK_APPLICATION_KEYSET = "jwks";

    static Config createHazelcastConfig() {
        System.setProperty("hazelcast.config.schema.validation.enabled", "false");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String resource = "ff-hazelcast.xml";
        PropertyLoader properties = new PropertyLoader(classLoader, "hazelcast.properties");
        String hazelcastNetworkConfig = properties.getString("hazelcast.network.file", null);
        if (StringUtils.isBlank((CharSequence)hazelcastNetworkConfig)) {
            throw new IllegalStateException("property [hazelcast.network.file] not specified");
        }
        log.info("Starting Hazelcast with network configuration: {}", (Object)hazelcastNetworkConfig);
        Config config = Config.loadFromClasspath((ClassLoader)classLoader, (String)resource, (Properties)properties);
        if (properties.getBoolean("hazelcast.liteMember", false)) {
            config.setLiteMember(true);
        }
        config.getNetworkConfig().getJoin().getAutoDetectionConfig().setEnabled(false);
        return config;
    }

    private static String computeName() {
        int instanceNum = FACTORY_ID_GEN.incrementAndGet();
        return MobyNames.getRandomName((int)instanceNum);
    }

    static HazelcastInstance newHazelcastInstance(@Nonnull InstanceType type, @Nonnull Map<String, String> attributes) {
        Objects.requireNonNull(attributes);
        Config config = HazelcastConfig.createHazelcastConfig();
        String name = HazelcastConfig.computeName();
        config.getMemberAttributeConfig().setAttribute(ATTRIBUTE_TYPE_KEY, type.name());
        config.getMemberAttributeConfig().setAttribute(ATTRIBUTE_NAME_KEY, name);
        if (VERSION != null) {
            config.getMemberAttributeConfig().setAttribute(ATTRIBUTE_VERSION_KEY, VERSION);
        }
        attributes.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))).forEach(e -> config.getMemberAttributeConfig().setAttribute((String)e.getKey(), (String)e.getValue()));
        return HazelcastInstanceFactory.newHazelcastInstance((Config)config, (String)name, (NodeContext)new DefaultNodeContext());
    }

    static enum InstanceType {
        CONTROLLER,
        WORKER;

    }
}

