/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.gateway;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.management.bus.BusException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;

public class ErrorMessageConverter
extends AbstractReplyProducingMessageHandler {
    private final Logger log = LogManager.getLogger(ErrorMessageConverter.class);

    public ErrorMessageConverter() {
        this.setRequiresReply(true);
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object object = requestMessage.getPayload();
        if (object instanceof Exception) {
            Exception e = (Exception)object;
            this.log.error("an error occurred while handling frank-management-bus request", (Throwable)e);
            if (e instanceof MessageDeliveryException) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            Throwable throwable = e.getCause();
            if (throwable instanceof BusException) {
                BusException ex = (BusException)throwable;
                return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.valueOf((int)ex.getStatusCode()));
            }
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

