/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.bus.message;

import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MimeType;

public class MessageBase<T>
implements Message<T> {
    public static final String STATUS_KEY = "status";
    public static final String MIMETYPE_KEY = "type";
    public static final String CONTENT_DISPOSITION_KEY = "contentdisposition";
    public static final String STATE_KEY = "state";
    private final T payload;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private MessageHeaders messageHeaders;

    protected MessageBase(T payload, MimeType defaultMimeType) {
        this.payload = payload;
        this.setStatus(200);
        this.setMimeType(defaultMimeType);
    }

    public void setStatus(int status) {
        if (status < 200 || status > 599) {
            throw new IllegalArgumentException("Status code [" + status + "] must be between 200 and 599");
        }
        this.setHeader(STATUS_KEY, String.valueOf(status));
    }

    protected void setMimeType(MimeType mimeType) {
        if (mimeType != null) {
            this.setHeader(MIMETYPE_KEY, mimeType.toString());
        }
    }

    public void setFilename(String filename) {
        this.setFilename("attachment", filename);
    }

    public void setFilename(String disposition, String filename) {
        this.setHeader(CONTENT_DISPOSITION_KEY, disposition + "; filename=\"" + filename + "\"");
    }

    public void setHeader(String key, String value) {
        this.headers.put("meta-" + key, value);
    }

    public T getPayload() {
        return this.payload;
    }

    public MessageHeaders getHeaders() {
        if (this.messageHeaders == null) {
            this.messageHeaders = new MessageHeaders(this.headers);
        }
        return this.messageHeaders;
    }
}

