/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.bus.message;

import jakarta.json.Json;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.frankframework.management.bus.message.StringMessage;
import org.frankframework.util.JacksonUtils;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

public class JsonMessage
extends StringMessage {
    private static final JsonWriterFactory WRITER_FACTORY;

    public JsonMessage(Object payload) {
        super(JacksonUtils.convertToJson(payload), (MimeType)MediaType.APPLICATION_JSON);
    }

    public JsonMessage(JsonStructure payload) {
        super(JsonMessage.jsonStructureToString(payload), (MimeType)MediaType.APPLICATION_JSON);
    }

    private static String jsonStructureToString(JsonStructure payload) {
        StringWriter writer = new StringWriter();
        try (JsonWriter jsonWriter = WRITER_FACTORY.createWriter((Writer)writer);){
            jsonWriter.write(payload);
        }
        return ((Object)writer).toString();
    }

    static {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", false);
        WRITER_FACTORY = Json.createWriterFactory(config);
    }
}

