/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.bus;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.frankframework.management.bus.OutboundGateway;
import org.frankframework.util.SpringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public class OutboundGatewayFactory
implements InitializingBean,
ApplicationContextAware,
FactoryBean<OutboundGateway> {
    private final Logger log = LogManager.getLogger((Object)this);
    private ApplicationContext applicationContext;
    private OutboundGateway gateway;
    private static final String GATEWAY_CLASS_KEY = "management.gateway.outbound.class";
    private String gatewayClassname = null;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.gatewayClassname)) {
            throw new IllegalStateException("no outbound gateway class specified. Please set [management.gateway.outbound.class]");
        }
        this.log.info("attempting to initialize using gateway class [{}]", (Object)this.gatewayClassname);
        Class gatewayClass = ClassUtils.resolveClassName((String)this.gatewayClassname, (ClassLoader)this.applicationContext.getClassLoader());
        if (!OutboundGateway.class.isAssignableFrom(gatewayClass)) {
            throw new IllegalArgumentException("gateway [" + this.gatewayClassname + "] does not implement type IntegrationGateway");
        }
        this.gateway = (OutboundGateway)SpringUtils.createBean((ApplicationContext)this.applicationContext, (Class)gatewayClass);
        this.log.info("created gateway [{}]", (Object)this.gateway);
    }

    public OutboundGateway getObject() {
        return this.gateway;
    }

    public Class<? extends OutboundGateway> getObjectType() {
        return this.gateway != null ? this.gateway.getClass() : OutboundGateway.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public void setGatewayClassname(String gatewayClassname) {
        this.gatewayClassname = gatewayClassname;
    }
}

