/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.bus;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.frankframework.management.bus.BusException;
import org.frankframework.management.bus.OutboundGateway;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class LocalGateway
extends MessagingGatewaySupport
implements OutboundGateway {
    private static long DEFAULT_REQUEST_TIMEOUT = 1000L;

    protected void onInit() {
        if (this.getRequestChannel() == null) {
            MessageChannel requestChannel = (MessageChannel)this.getApplicationContext().getBean("frank-management-bus", MessageChannel.class);
            this.setRequestChannel(requestChannel);
        }
        this.setRequestTimeout(DEFAULT_REQUEST_TIMEOUT);
        this.setReplyTimeout(DEFAULT_REQUEST_TIMEOUT);
        super.onInit();
    }

    @Override
    @Nonnull
    public <I, O> Message<O> sendSyncMessage(Message<I> requestMessage) {
        Message replyMessage = super.sendAndReceiveMessage(requestMessage);
        if (replyMessage != null) {
            return replyMessage;
        }
        long timeout = this.getSendTimeout(requestMessage) + this.getReceiveTimeout(requestMessage);
        throw new BusException("no reponse found on reply-queue within receiveTimeout [" + timeout + "]");
    }

    private long getSendTimeout(Message<?> requestMessage) {
        Long sendTimeout = this.convertHeaderToLong(requestMessage.getHeaders().get((Object)"sendTimeout"));
        return sendTimeout != null ? sendTimeout : DEFAULT_REQUEST_TIMEOUT;
    }

    private long getReceiveTimeout(Message<?> requestMessage) {
        Long sendTimeout = this.convertHeaderToLong(requestMessage.getHeaders().get((Object)"receiveTimeout"));
        return sendTimeout != null ? sendTimeout : DEFAULT_REQUEST_TIMEOUT;
    }

    @Nullable
    private Long convertHeaderToLong(@Nullable Object headerValue) {
        if (headerValue instanceof Number) {
            return ((Number)headerValue).longValue();
        }
        if (headerValue instanceof String) {
            return Long.parseLong((String)headerValue);
        }
        return null;
    }

    @Override
    public <I> void sendAsyncMessage(Message<I> in) {
        super.send(in);
    }

    public MessageChannel getErrorChannel() {
        return null;
    }
}

