/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.management.bus;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.frankframework.util.ClassUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class BusMessageUtils {
    public static final String HEADER_DATASOURCE_NAME_KEY = "datasourceName";
    public static final String HEADER_CONNECTION_FACTORY_NAME_KEY = "connectionFactory";
    public static final String HEADER_CONFIGURATION_NAME_KEY = "configuration";
    public static final String HEADER_ADAPTER_NAME_KEY = "adapter";
    public static final String HEADER_RECEIVER_NAME_KEY = "receiver";
    public static final String HEADER_TARGET_KEY = "target";
    private static final Logger LOG = LogManager.getLogger(BusMessageUtils.class);
    public static final String HEADER_PREFIX = "meta-";
    public static final String HEADER_PREFIX_PATTERN = "meta-*";
    public static final String ALL_CONFIGS_KEY = "*ALL*";

    @Nullable
    private static <T> T getHeader(Message<?> message, String headerName, Class<T> type) {
        MessageHeaders headers = message.getHeaders();
        if (BusMessageUtils.contains(headers, headerName)) {
            Object rawValue = headers.get((Object)(HEADER_PREFIX + headerName));
            if (rawValue == null) {
                return null;
            }
            if (type.isAssignableFrom(rawValue.getClass())) {
                return (T)rawValue;
            }
            if (rawValue instanceof String) {
                try {
                    return (T)ClassUtils.convertToType(type, (String)String.valueOf(rawValue));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("unable to convert header to required type", (Throwable)e);
                }
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = rawValue::getClass;
                LOG.warn("conversion of type [{}] not implemented", supplierArray);
            }
        }
        return null;
    }

    private static boolean contains(MessageHeaders headers, String headerName) {
        return headers.get((Object)(HEADER_PREFIX + headerName)) != null;
    }

    public static boolean containsHeader(Message<?> message, String headerName) {
        return BusMessageUtils.contains(message.getHeaders(), headerName);
    }

    @Nullable
    public static String getHeader(Message<?> message, String headerName) {
        return BusMessageUtils.getHeader(message, headerName, String.class);
    }

    public static String getHeader(Message<?> message, String headerName, String defaultValue) {
        String headerValue = BusMessageUtils.getHeader(message, headerName, String.class);
        return StringUtils.isNotBlank((CharSequence)headerValue) ? headerValue : defaultValue;
    }

    public static Integer getIntHeader(Message<?> message, String headerName, Integer defaultValue) {
        Integer headerValue = BusMessageUtils.getHeader(message, headerName, Integer.class);
        return headerValue != null ? headerValue : defaultValue;
    }

    public static Boolean getBooleanHeader(Message<?> message, String headerName, Boolean defaultValue) {
        Boolean headerValue = BusMessageUtils.getHeader(message, headerName, Boolean.class);
        return headerValue != null ? headerValue : defaultValue;
    }

    public static <E extends Enum<E>> E getEnumHeader(Message<?> message, String headerName, Class<E> enumClazz) {
        return BusMessageUtils.getEnumHeader(message, headerName, enumClazz, null);
    }

    public static <E extends Enum<E>> E getEnumHeader(Message<?> message, String headerName, Class<E> enumClazz, E defaultValue) {
        Enum headerValue = (Enum)BusMessageUtils.getHeader(message, headerName, enumClazz);
        return (E)(headerValue != null ? headerValue : defaultValue);
    }

    @Nullable
    public static String getUserPrincipalName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return null;
    }

    @Nonnull
    private static Collection<? extends GrantedAuthority> getAuthorities() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return authentication.getAuthorities();
        }
        return Collections.emptyList();
    }

    public static boolean hasAnyRole(String ... roles) {
        for (String role : roles) {
            if (!BusMessageUtils.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRole(String role) {
        boolean granted = false;
        for (GrantedAuthority grantedAuthority : BusMessageUtils.getAuthorities()) {
            String authorityName = grantedAuthority.getAuthority().substring(5);
            granted = authorityName.equals(role);
            if (!granted) continue;
            return true;
        }
        return granted;
    }
}

