/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.foxlabs.util.resource.ResourceError;
import org.foxlabs.util.resource.ResourceHelper;

public abstract class Service {
    public static final String DIRECTORY = "META-INF/services/";

    private Service() {
    }

    public static <P> Iterator<P> lookup(Class<P> category) {
        return Service.lookup(category, ResourceHelper.getClassLoader());
    }

    public static <P> Iterator<P> lookup(Class<P> category, ClassLoader cl) {
        return new ProviderItr(category, cl);
    }

    public static <P> P lookupFirst(Class<P> category) {
        return Service.lookupFirst(category, ResourceHelper.getClassLoader());
    }

    public static <P> P lookupFirst(Class<P> category, ClassLoader cl) {
        ProviderItr itr = new ProviderItr(category, cl);
        return itr.hasNext() ? (P)itr.next() : null;
    }

    public static <P> Iterator<Class<? extends P>> lookupClasses(Class<P> category) {
        return Service.lookupClasses(category, ResourceHelper.getClassLoader());
    }

    public static <P> Iterator<Class<? extends P>> lookupClasses(Class<P> category, ClassLoader cl) {
        return new ProviderClassItr(category, cl);
    }

    protected static class ProviderClassItr<P>
    implements Iterator<Class<? extends P>> {
        private final Class<P> category;
        private final ClassLoader loader;
        private Enumeration<URL> files;
        private URL file;
        private BufferedReader reader;
        private Class<? extends P> next;
        private final Map<String, Class<? extends P>> cache = new HashMap<String, Class<? extends P>>();

        private ProviderClassItr(Class<P> category, ClassLoader cl) {
            try {
                this.files = cl.getResources(Service.DIRECTORY + category.getName());
                this.category = category;
                this.loader = cl;
            }
            catch (IOException e) {
                throw new ResourceError("An error occured when locating category \"" + category.getName() + "\" provider-configuration files", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null) {
                try {
                    if (this.reader == null) {
                        if (this.files.hasMoreElements()) {
                            this.file = this.files.nextElement();
                            this.reader = new BufferedReader(new InputStreamReader(this.file.openStream(), "UTF-8"));
                        } else {
                            return false;
                        }
                    }
                    boolean fail = true;
                    try {
                        String line = this.reader.readLine();
                        fail = false;
                        if (line == null) {
                            this.reader.close();
                            this.reader = null;
                            continue;
                        }
                        this.next = this.parseLine(line);
                    }
                    finally {
                        if (!fail) continue;
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    throw new ResourceError("An error occured when reading provider-configuration file (" + this.file + ")", e);
                }
            }
            return true;
        }

        @Override
        public Class<? extends P> next() {
            if (this.hasNext()) {
                Class<? extends P> cls = this.next;
                this.next = null;
                return cls;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Class<? extends P> parseLine(String line) {
            int index = line.indexOf(35);
            String name = (index < 0 ? line : line.substring(0, index)).trim();
            if (name.isEmpty()) {
                return null;
            }
            Class<Object> cls = this.cache.get(name);
            if (cls != null) {
                return cls;
            }
            try {
                cls = this.loader.loadClass(name).asSubclass(this.category);
                this.cache.put(name, cls);
                return cls;
            }
            catch (ClassNotFoundException e) {
                throw new ResourceError("Service provider \"" + name + "\" is not found (" + this.file + ")");
            }
            catch (ClassCastException e) {
                throw new ResourceError("Service provider \"" + name + "\" should implement " + this.category.getName() + " (" + this.file + ")");
            }
        }
    }

    protected static class ProviderItr<P>
    implements Iterator<P> {
        private final ProviderClassItr<? extends P> clsItr;
        private final Map<Class<?>, P> cache = new HashMap();

        private ProviderItr(Class<P> category, ClassLoader cl) {
            this.clsItr = new ProviderClassItr(category, cl);
        }

        @Override
        public boolean hasNext() {
            return this.clsItr.hasNext();
        }

        @Override
        public P next() {
            Object cls = this.clsItr.next();
            Object provider = this.cache.get(cls);
            if (provider != null) {
                return provider;
            }
            try {
                provider = ((Class)cls).newInstance();
                this.cache.put((Class<?>)cls, provider);
                return provider;
            }
            catch (Throwable e) {
                throw new ResourceError("Can't instantiate \"" + ((Class)cls).getName() + "\" service provider (" + ((ProviderClassItr)this.clsItr).file + ")", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

