/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.foxlabs.util.ByteBuffer;
import org.foxlabs.util.resource.ResourceError;

public abstract class ResourceHelper {
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_ENCODING = "utf-8";

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null && (cl = ResourceHelper.class.getClassLoader()) == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static ClassLoader getClassLoader(ClassLoader cl) {
        return cl == null ? ResourceHelper.getClassLoader() : cl;
    }

    public static String getPackageName(Class<?> c) {
        return c.getPackage().getName();
    }

    public static String getResourcePath(Class<?> c) {
        return ResourceHelper.getPackageName(c).replace('.', '/');
    }

    public static URL getResourceURL(String name) {
        return ResourceHelper.getResourceURL(name, ResourceHelper.getClassLoader());
    }

    public static URL getResourceURL(String name, ClassLoader cl) {
        URL url = cl.getResource(name);
        if (url == null) {
            throw new ResourceError("Unable to find resource: \"" + name + "\"");
        }
        return url;
    }

    public static byte[] readBinaryResource(String name) {
        return ResourceHelper.readBinaryResource(name, ResourceHelper.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryResource(String name, ClassLoader cl) {
        byte[] byArray;
        URL url = ResourceHelper.getResourceURL(name, cl);
        InputStream in = url.openStream();
        try {
            byte[] chunk = new byte[8192];
            ByteBuffer buf = new ByteBuffer(chunk.length);
            int len = in.read(chunk);
            while (len > 0) {
                buf.append(chunk, 0, len);
                len = in.read(chunk);
            }
            byArray = buf.getBytes();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceError("Error reading resource: \"" + name + "\"", e);
            }
        }
        in.close();
        return byArray;
    }

    public static String readTextResource(String name) {
        return ResourceHelper.readTextResource(name, DEFAULT_ENCODING, ResourceHelper.getClassLoader());
    }

    public static String readTextResource(String name, ClassLoader cl) {
        return ResourceHelper.readTextResource(name, DEFAULT_ENCODING, cl);
    }

    public static String readTextResource(String name, String encoding) {
        return ResourceHelper.readTextResource(name, encoding, ResourceHelper.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextResource(String name, String encoding, ClassLoader cl) {
        String string;
        URL url = ResourceHelper.getResourceURL(name, cl);
        InputStream in = url.openStream();
        try {
            InputStreamReader cin = new InputStreamReader(in, encoding);
            char[] chunk = new char[8192];
            StringBuilder buf = new StringBuilder(chunk.length);
            int len = cin.read(chunk);
            while (len > 0) {
                buf.append(chunk, 0, len);
                len = cin.read(chunk);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceError("Error reading resource: \"" + name + "\"", e);
            }
        }
        in.close();
        return string;
    }

    public static Class<?>[] findClasses(String pkg, boolean recurse) {
        return ResourceHelper.findClasses(pkg, ResourceHelper.getClassLoader(), recurse);
    }

    public static Class<?>[] findClasses(String pkg, ClassLoader cl, boolean recurse) {
        File dir;
        ArrayList classes = new ArrayList();
        URL url = cl.getResource(pkg.replace('.', '/'));
        if (url != null && (dir = new File(url.getFile())).isDirectory()) {
            ResourceHelper.findClasses(dir, pkg, cl, classes, recurse);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void findClasses(File dir, String pkg, ClassLoader cl, List<Class<?>> classes, boolean recurse) {
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                String name = file.getName();
                if (!name.endsWith(".class")) continue;
                String className = pkg + "." + name.substring(0, name.length() - 6);
                try {
                    classes.add(cl.loadClass(className));
                }
                catch (ClassNotFoundException e) {}
                continue;
            }
            if (!recurse || !file.isDirectory()) continue;
            ResourceHelper.findClasses(file, pkg + "." + file.getName(), cl, classes, recurse);
        }
    }
}

