/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.resource;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.foxlabs.util.resource.ResourceError;
import org.foxlabs.util.resource.ResourceHelper;

public final class MessageBundle {
    private final String baseName;
    private final ClassLoader classLoader;
    private final MessageBundle parentBundle;
    private static final ConcurrentMap<MessageBundle, MessageBundle> bundleCache = new ConcurrentHashMap<MessageBundle, MessageBundle>();

    private MessageBundle(String name, ClassLoader loader, MessageBundle parent) {
        this.baseName = name;
        this.classLoader = loader;
        this.parentBundle = parent;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MessageBundle getParentBundle() {
        return this.parentBundle;
    }

    public boolean isAssignableFrom(MessageBundle bundle) {
        return this.baseName.equals(bundle.baseName) && this.classLoader.equals(bundle.classLoader) || this.parentBundle != null && this.parentBundle.isAssignableFrom(bundle);
    }

    public boolean contains(String key) {
        return this.getResourceBundle(Locale.ROOT).containsKey(key) || this.parentBundle != null && this.parentBundle.contains(key);
    }

    public String get(String key) {
        return this.get(key, Locale.getDefault());
    }

    public String get(String key, Locale locale) {
        try {
            return this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException e) {
            if (this.parentBundle != null) {
                try {
                    return this.parentBundle.get(key);
                }
                catch (MissingResourceException unused) {
                    // empty catch block
                }
            }
            throw new MissingResourceException("Can't find message \"" + key + "\": " + this, e.getClassName(), key);
        }
    }

    public String format(String key, Object ... args) {
        return this.format(key, Locale.getDefault(), args);
    }

    public String format(String key, Locale locale, Object ... args) {
        return new MessageFormat(this.get(key, locale), locale).format(args);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.baseName, locale, this.classLoader);
        }
        catch (MissingResourceException e) {
            throw new ResourceError("Can't find resource bundle: " + this.baseName);
        }
    }

    public int hashCode() {
        int hash = 31 * this.baseName.hashCode() + this.classLoader.hashCode();
        return this.parentBundle == null ? hash : 31 * hash + this.parentBundle.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageBundle) {
            MessageBundle other = (MessageBundle)obj;
            if (this.baseName.equals(other.baseName) && this.classLoader.equals(other.classLoader)) {
                return this.parentBundle == null ? other.parentBundle == null : this.parentBundle.equals(other.parentBundle);
            }
        }
        return false;
    }

    public String toString() {
        if (this.parentBundle == null) {
            return this.baseName;
        }
        StringBuilder buf = new StringBuilder(this.baseName);
        MessageBundle bundle = this.parentBundle;
        while (bundle != null) {
            buf.append(", ").append(bundle.baseName);
            bundle = bundle.parentBundle;
        }
        return buf.toString();
    }

    public static MessageBundle getInstance(String name) {
        return MessageBundle.getInstance(name, null, null);
    }

    public static MessageBundle getInstance(String name, ClassLoader loader) {
        return MessageBundle.getInstance(name, loader, null);
    }

    public static MessageBundle getInstance(String name, MessageBundle parent) {
        return MessageBundle.getInstance(name, null, parent);
    }

    public static MessageBundle getInstance(String name, ClassLoader loader, MessageBundle parent) {
        MessageBundle bundle = new MessageBundle(name, ResourceHelper.getClassLoader(loader), parent);
        if (parent == null) {
            MessageBundle cached = (MessageBundle)bundleCache.get(bundle);
            if (cached != null) {
                return cached;
            }
            bundleCache.put(bundle, bundle);
            return bundle;
        }
        return bundle.baseName.equals(parent.baseName) && bundle.classLoader.equals(parent.classLoader) ? parent : bundle;
    }
}

