/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;

public abstract class Types {
    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Class<?>[] typesOf(Object ... objs) {
        Class[] types = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            types[i] = objs[i] == null ? Object.class : (objs[i] instanceof Annotation ? ((Annotation)objs[i]).annotationType() : objs[i].getClass());
        }
        return types;
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.class || type == Byte.TYPE;
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.class || type == Short.TYPE;
    }

    public static boolean isInteger(Class<?> type) {
        return type == Integer.class || type == Integer.TYPE;
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.class || type == Long.TYPE;
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.class || type == Float.TYPE;
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.class || type == Double.TYPE;
    }

    public static boolean isObject(Class<?> type) {
        return type != null && !type.isPrimitive() && !type.isArray() && !type.isEnum() && !type.isAnnotation();
    }

    public static <T> Class<T> wrapperTypeOf(Class<T> type) {
        if (type != null && type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
        }
        return type;
    }

    public static Class<?> primitiveTypeOf(Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    public static <T> T defaultValueOf(Class<T> type) {
        if (type != null && type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
        }
        return null;
    }

    public static Class<?> superTypeOf(Class<?> type) {
        return type == null ? Object.class : type;
    }

    public static Class<?> superTypeOf(Class<?> type1, Class<?> type2) {
        if (type1 == type2) {
            return type1;
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return Object.class;
    }

    public static Class<?> superTypeOf(Class<?> ... types) {
        int count = types.length;
        if (count == 0) {
            return Object.class;
        }
        Class<?> type = types[0];
        if (count == 1) {
            return Types.superTypeOf(type);
        }
        for (int i = 1; i < count; ++i) {
            if ((type = Types.superTypeOf(type, types[i])) != Object.class) continue;
            return Object.class;
        }
        return type;
    }

    public static <T> Class<T> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Types.arrayTypeOf(Types.rawTypeOf(((GenericArrayType)type).getGenericComponentType()));
        }
        return Object.class;
    }

    public static <T, E> Class<T> arrayTypeOf(Class<E> elementType) {
        if (elementType == null) {
            return Object[].class;
        }
        return Array.newInstance(elementType, 0).getClass();
    }

    public static <T> Class<T> elementTypeOf(Type type) {
        Class<T> rawtype = Types.rawTypeOf(type);
        if (rawtype.isArray()) {
            return rawtype.getComponentType();
        }
        if (Collection.class.isAssignableFrom(rawtype)) {
            if (type instanceof Class) {
                return Types.parameterTypeOf((Class)type, Collection.class, 0);
            }
            if (type instanceof ParameterizedType) {
                Type[] argtypes = ((ParameterizedType)type).getActualTypeArguments();
                return argtypes.length == 0 ? Object.class : Types.rawTypeOf(argtypes[0]);
            }
        } else if (Map.class.isAssignableFrom(rawtype)) {
            if (type instanceof Class) {
                return Types.parameterTypeOf((Class)type, Map.class, 1);
            }
            if (type instanceof ParameterizedType) {
                Type[] argtypes = ((ParameterizedType)type).getActualTypeArguments();
                return argtypes.length < 2 ? Object.class : Types.rawTypeOf(argtypes[1]);
            }
        }
        return null;
    }

    public static <T> Class<T> keyTypeOf(Type type) {
        if (Map.class.isAssignableFrom(Types.rawTypeOf(type))) {
            if (type instanceof Class) {
                return Types.parameterTypeOf((Class)type, Map.class, 0);
            }
            if (type instanceof ParameterizedType) {
                Type[] argtypes = ((ParameterizedType)type).getActualTypeArguments();
                return argtypes.length < 1 ? Object.class : Types.rawTypeOf(argtypes[0]);
            }
        }
        return null;
    }

    public static Class<?> parameterTypeOf(Class<?> type, Class<?> base, int index) {
        LinkedList<Type> supertypes = new LinkedList<Type>();
        if (type.getGenericSuperclass() != null) {
            supertypes.add(type.getGenericSuperclass());
        }
        for (Type intf : type.getGenericInterfaces()) {
            supertypes.add(intf);
        }
        for (Type supertype : supertypes) {
            Type[] argtypes;
            Class rawtype = Types.rawTypeOf(supertype);
            if (!base.isAssignableFrom(rawtype)) continue;
            Class<?> paramtype = Types.parameterTypeOf(rawtype, base, index);
            if (paramtype != Object.class) {
                return paramtype;
            }
            if (!(supertype instanceof ParameterizedType) || index >= (argtypes = ((ParameterizedType)supertype).getActualTypeArguments()).length || !(argtypes[index] instanceof Class)) continue;
            return (Class)argtypes[index];
        }
        return Object.class;
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, E> T newArray(Class<E> elementType, int length) {
        return (T)Array.newInstance(elementType, length);
    }

    public static <T extends Collection<E>, E> T newCollection(Class<T> type, int size) {
        if (Collection.class.equals(type)) {
            return (T)((Collection)type.cast(new ArrayList(size)));
        }
        if (List.class.isAssignableFrom(type)) {
            return (T)((Collection)type.cast(Types.newList(type.asSubclass(List.class), size)));
        }
        if (Set.class.isAssignableFrom(type)) {
            return (T)((Collection)type.cast(Types.newSet(type.asSubclass(Set.class), size)));
        }
        if (Queue.class.isAssignableFrom(type)) {
            return (T)((Collection)type.cast(Types.newQueue(type.asSubclass(Queue.class), size)));
        }
        return (T)((Collection)Types.newInstance(type));
    }

    public static <T extends List<E>, E> T newList(Class<T> type, int size) {
        if (List.class.equals(type) || ArrayList.class.equals(type)) {
            return (T)((List)type.cast(new ArrayList(size)));
        }
        if (LinkedList.class.equals(type)) {
            return (T)((List)type.cast(new LinkedList()));
        }
        return (T)((List)Types.newInstance(type));
    }

    public static <T extends Set<E>, E> T newSet(Class<T> type, int size) {
        if (Set.class.equals(type) || LinkedHashSet.class.equals(type)) {
            return (T)((Set)type.cast(new LinkedHashSet(size)));
        }
        if (HashSet.class.equals(type)) {
            return (T)((Set)type.cast(new HashSet(size)));
        }
        if (SortedSet.class.equals(type) || NavigableSet.class.equals(type) || TreeSet.class.equals(type)) {
            return (T)((Set)type.cast(new TreeSet()));
        }
        if (ConcurrentSkipListSet.class.equals(type)) {
            return (T)((Set)type.cast(new ConcurrentSkipListSet()));
        }
        return (T)((Set)Types.newInstance(type));
    }

    public static <T extends Queue<E>, E> T newQueue(Class<T> type, int size) {
        if (Queue.class.equals(type) || PriorityQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new PriorityQueue(size)));
        }
        if (Deque.class.equals(type) || LinkedList.class.equals(type)) {
            return (T)((Queue)type.cast(new LinkedList()));
        }
        if (ArrayDeque.class.equals(type)) {
            return (T)((Queue)type.cast(new ArrayDeque(size)));
        }
        if (ConcurrentLinkedQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new ConcurrentLinkedQueue()));
        }
        if (BlockingQueue.class.equals(type) || LinkedBlockingQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new LinkedBlockingQueue(size)));
        }
        if (ArrayBlockingQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new ArrayBlockingQueue(size)));
        }
        if (PriorityBlockingQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new PriorityBlockingQueue(size)));
        }
        if (SynchronousQueue.class.equals(type)) {
            return (T)((Queue)type.cast(new SynchronousQueue()));
        }
        if (BlockingDeque.class.equals(type) || LinkedBlockingDeque.class.equals(type)) {
            return (T)((Queue)type.cast(new LinkedBlockingDeque(size)));
        }
        return (T)((Queue)Types.newInstance(type));
    }

    public static <T extends Map<K, V>, K, V> T newMap(Class<T> type, int size) {
        if (Map.class.equals(type) || LinkedHashMap.class.equals(type)) {
            return (T)((Map)type.cast(new LinkedHashMap(size)));
        }
        if (HashMap.class.equals(type)) {
            return (T)((Map)type.cast(new HashMap(size)));
        }
        if (IdentityHashMap.class.equals(type)) {
            return (T)((Map)type.cast(new IdentityHashMap(size)));
        }
        if (SortedMap.class.equals(type) || NavigableMap.class.equals(type) || TreeMap.class.equals(type)) {
            return (T)((Map)type.cast(new TreeMap()));
        }
        if (ConcurrentMap.class.equals(type) || ConcurrentHashMap.class.equals(type)) {
            return (T)((Map)type.cast(new ConcurrentHashMap(size)));
        }
        if (ConcurrentNavigableMap.class.equals(type) || ConcurrentSkipListMap.class.equals(type)) {
            return (T)((Map)type.cast(new ConcurrentSkipListMap()));
        }
        return (T)((Map)Types.newInstance(type));
    }

    public static int hashCode(Class<?> ... types) {
        if (types == null || types.length == 0) {
            return 0;
        }
        int hash = 1;
        for (Class<?> type : types) {
            hash = 31 * hash + (type == null ? 0 : type.hashCode());
        }
        return hash;
    }
}

