/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.reflect;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.foxlabs.util.reflect.PropertyGetter;
import org.foxlabs.util.reflect.PropertySetter;

public final class BeanIntrospector {
    private final Class<?> type;
    private final Map<Class<?>, Annotation> annotations;
    private final Map<String, Property> properties;
    private static final Map<Class<?>, BeanIntrospector> cache = new WeakHashMap();

    private BeanIntrospector(Class<?> type) {
        LinkedHashMap annotations = new LinkedHashMap();
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        this.type = type;
        Class<?> supertype = this.type.getSuperclass();
        if (supertype != null && supertype != Object.class) {
            BeanIntrospector parent = BeanIntrospector.getInstance(supertype);
            annotations.putAll(parent.annotations);
            properties.putAll(parent.properties);
        }
        BeanIntrospector.overrideAnnotations(type, annotations);
        BeanIntrospector.findProperties(type, properties);
        this.annotations = Collections.unmodifiableMap(annotations);
        this.properties = Collections.unmodifiableMap(properties);
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type);
        if (this.annotations.size() > 0) {
            buf.append(' ');
            BeanIntrospector.toString(this.annotations, buf);
        }
        for (Property property : this.properties.values()) {
            buf.append('\n').append(" - ");
            property.toString(buf);
        }
        return buf.toString();
    }

    static void findProperties(Class<?> type, Map<String, Property> properties) {
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                String propertyName;
                if (descriptor instanceof IndexedPropertyDescriptor || !BeanIntrospector.acceptProperty(type, propertyName = descriptor.getName())) continue;
                Class<?> propertyType = descriptor.getPropertyType();
                Method readMethod = descriptor.getReadMethod();
                Method writeMethod = descriptor.getWriteMethod();
                PropertyGetter getter = PropertyGetter.newGetter(readMethod);
                PropertySetter setter = PropertySetter.newSetter(writeMethod);
                Property property = properties.get(propertyName);
                LinkedHashMap annotations = new LinkedHashMap();
                if (property != null) {
                    annotations.putAll(property.annotations);
                }
                BeanIntrospector.overrideAnnotations(readMethod, annotations);
                BeanIntrospector.overrideAnnotations(writeMethod, annotations);
                property = new Property(propertyName, propertyType, getter, setter, annotations);
                properties.put(propertyName, property);
            }
        }
        catch (IntrospectionException e) {
            throw new InternalError();
        }
    }

    static boolean acceptProperty(Class<?> type, String name) {
        return !"class".equals(name);
    }

    static void overrideAnnotations(AnnotatedElement source, Map<Class<?>, Annotation> annotations) {
        if (source != null) {
            for (Annotation annotation : source.getAnnotations()) {
                annotations.put(annotation.annotationType(), annotation);
            }
        }
    }

    static void toString(Map<Class<?>, Annotation> annotations, StringBuilder buf) {
        Iterator<Annotation> itr = annotations.values().iterator();
        if (itr.hasNext()) {
            buf.append('(');
            buf.append(itr.next());
            while (itr.hasNext()) {
                buf.append(',').append(itr.next());
            }
            buf.append(')');
        }
    }

    public static synchronized BeanIntrospector getInstance(Class<?> type) {
        BeanIntrospector introspector = cache.get(type);
        if (introspector == null) {
            introspector = new BeanIntrospector(type);
            cache.put(type, introspector);
        }
        return introspector;
    }

    public static final class Property {
        private final String name;
        private final Class<?> type;
        private final PropertyGetter getter;
        private final PropertySetter setter;
        private final Map<Class<?>, Annotation> annotations;

        private Property(String name, Class<?> type, PropertyGetter getter, PropertySetter setter, Map<Class<?>, Annotation> annotations) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
            this.annotations = annotations;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.isReadable() ? this.getter.getGenericType() : this.setter.getGenericType();
        }

        public PropertyGetter getGetter() {
            return this.getter;
        }

        public PropertySetter getSetter() {
            return this.setter;
        }

        public boolean isReadable() {
            return this.getter != null;
        }

        public boolean isWriteable() {
            return this.setter != null;
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.annotations.containsKey(annotationType);
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
        }

        public Annotation[] getAnnotations() {
            return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        public void toString(StringBuilder buf) {
            buf.append(this.type.getName());
            buf.append(' ');
            buf.append(this.name);
            if (this.annotations.size() > 0) {
                buf.append(' ');
                BeanIntrospector.toString(this.annotations, buf);
            }
        }
    }
}

