/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;

public final class UnicodeSet
implements Serializable {
    private static final long serialVersionUID = 6383904768150245166L;
    public static final int MIN_ELEMENT = 0;
    public static final int MAX_ELEMENT = 0x10FFFF;
    public static final UnicodeSet EMPTY = new UnicodeSet(new int[0], new int[0]);
    public static final UnicodeSet WHOLE = new UnicodeSet(new int[]{0}, new int[]{0x10FFFF});
    public static final UnicodeSet ASCII = new UnicodeSet(new int[]{0}, new int[]{127});
    public static final UnicodeSet DIGIT = new UnicodeSet(48, 57);
    public static final UnicodeSet ALPHA = new UnicodeSet(new int[]{65, 97}, new int[]{90, 122});
    public static final UnicodeSet ALNUM = DIGIT.union(ALPHA);
    public static final UnicodeSet SPACE = UnicodeSet.fromElements(" \t\n\r\f\b");
    public static final UnicodeSet PRINT = UnicodeSet.unionAll(ALNUM, SPACE, UnicodeSet.fromElements("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~"));
    private int[] min;
    private int[] max;
    private transient UnicodeSet inverse;
    private transient int hash;

    private UnicodeSet(int min, int max) {
        this(new int[]{min}, new int[]{max});
    }

    private UnicodeSet(int[] min, int[] max) {
        this.min = min;
        this.max = max;
    }

    public int size() {
        return this.min.length;
    }

    public int getMin() {
        return this.min.length > 0 ? this.min[0] : -1;
    }

    public int getMax() {
        return this.max.length > 0 ? this.max[this.max.length - 1] : -1;
    }

    public boolean isElementSet() {
        for (int i = 0; i < this.min.length; ++i) {
            if (this.min[i] >= this.max[i]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int ch) {
        if (this == EMPTY) {
            return false;
        }
        if (this == WHOLE) {
            return ch >= 0 && ch <= 0x10FFFF;
        }
        return this.contains(ch, 0, this.min.length - 1);
    }

    private boolean contains(int ch, int i, int j) {
        if (ch < this.min[i] || ch > this.max[j]) {
            return false;
        }
        if (i < j) {
            int m = i + (j - i) / 2 + 1;
            return this.contains(ch, i, m - 1) || this.contains(ch, m, j);
        }
        return true;
    }

    public UnicodeSet union(UnicodeSet uset) {
        return UnicodeSet.unionAll(this, uset);
    }

    public UnicodeSet inverse() {
        int[] max;
        int[] min;
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this == EMPTY) {
            this.inverse = WHOLE;
            return this.inverse;
        }
        if (this == WHOLE) {
            this.inverse = EMPTY;
            return this.inverse;
        }
        int n = this.min[0];
        int m = this.max[this.max.length - 1];
        int size = this.min.length;
        int j = 0;
        if (n == 0) {
            if (m == 0x10FFFF) {
                min = new int[size - 1];
                max = new int[size - 1];
            } else {
                min = new int[size];
                max = new int[size];
                min[min.length - 1] = m + 1;
                max[max.length - 1] = 0x10FFFF;
            }
        } else if (m == 0x10FFFF) {
            min = new int[size];
            max = new int[size];
            min[0] = 0;
            max[0] = n - 1;
            j = 1;
        } else {
            min = new int[size + 1];
            max = new int[size + 1];
            min[0] = 0;
            max[0] = n - 1;
            min[min.length - 1] = m + 1;
            max[max.length - 1] = 0x10FFFF;
            j = 1;
        }
        int i = 1;
        while (i < size) {
            min[j] = this.max[i - 1] + 1;
            max[j] = this.min[i] - 1;
            ++i;
            ++j;
        }
        this.inverse = UnicodeSet.valueOf(min, max);
        return this.inverse;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int hash = 1;
            for (int i = 0; i < this.min.length; ++i) {
                hash = 31 * (31 * hash + this.min[i]) + this.max[i];
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnicodeSet) {
            UnicodeSet other = (UnicodeSet)obj;
            if (this.min.length != other.min.length) {
                return false;
            }
            for (int i = 0; i < this.min.length; ++i) {
                if (this.min[i] == other.min[i] && this.max[i] == other.max[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] toArray() {
        int[] intervals = new int[this.min.length * 2];
        int j = 0;
        for (int i = 0; i < this.min.length; ++i) {
            intervals[j++] = this.min[i];
            intervals[j++] = this.max[i];
        }
        return intervals;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        buf.append('[');
        if (this.min.length > 0) {
            UnicodeSet.toString(buf, this.min[0], this.max[0]);
            for (int i = 1; i < this.min.length; ++i) {
                buf.append(',');
                UnicodeSet.toString(buf, this.min[i], this.max[i]);
            }
        }
        buf.append(']');
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.min.length);
        for (int i = 0; i < this.min.length; ++i) {
            stream.writeInt(this.min[i]);
            stream.writeInt(this.max[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.min = new int[size];
        this.max = new int[size];
        for (int i = 0; i < size; ++i) {
            this.min[i] = stream.readInt();
            this.max[i] = stream.readInt();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return EMPTY.equals(this) ? EMPTY : (WHOLE.equals(this) ? WHOLE : this);
    }

    private static void toString(StringBuilder buf, int n, int m) {
        buf.append('\'').append(UnicodeSet.escape((char)n)).append('\'');
        if (n < m) {
            buf.append('-').append('\'').append(UnicodeSet.escape((char)m)).append('\'');
        }
    }

    public static UnicodeSet unionAll(UnicodeSet ... usets) {
        int length = usets.length;
        if (length == 0) {
            return EMPTY;
        }
        if (length == 1) {
            return usets[0];
        }
        int size = 0;
        for (UnicodeSet uset : usets) {
            if (uset == WHOLE) {
                return WHOLE;
            }
            size += uset.size();
        }
        if (size == 0) {
            return EMPTY;
        }
        int[] min = new int[size];
        int[] max = new int[size];
        int offset = 0;
        for (int i = 0; i < length; ++i) {
            UnicodeSet uset = usets[i];
            if (uset == EMPTY) continue;
            int delta = uset.size();
            System.arraycopy(uset.min, 0, min, offset, delta);
            System.arraycopy(uset.max, 0, max, offset, delta);
            offset += delta;
        }
        return UnicodeSet.valueOf(min, max);
    }

    public static UnicodeSet fromElements(char ... elements) {
        int length = elements.length;
        if (length == 0) {
            return EMPTY;
        }
        int[] intervals = new int[length * 2];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int ch = elements[i];
            intervals[j++] = ch;
            intervals[j++] = ch;
        }
        return UnicodeSet.fromIntervals(intervals);
    }

    public static UnicodeSet fromElements(int[] elements) {
        int length = elements.length;
        if (length == 0) {
            return EMPTY;
        }
        int[] intervals = new int[length * 2];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int ch = elements[i];
            intervals[j++] = ch;
            intervals[j++] = ch;
        }
        return UnicodeSet.fromIntervals(intervals);
    }

    public static UnicodeSet fromElements(String elements) {
        int length = elements.length();
        if (length == 0) {
            return EMPTY;
        }
        int[] intervals = new int[length * 2];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int ch = elements.codePointAt(i);
            intervals[j++] = ch;
            intervals[j++] = ch;
        }
        return UnicodeSet.fromIntervals(intervals);
    }

    public static UnicodeSet fromIntervals(char ... intervals) {
        int length = intervals.length;
        if (length % 2 > 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return EMPTY;
        }
        int size = length / 2;
        int[] min = new int[size];
        int[] max = new int[size];
        int j = 0;
        for (int i = 0; i < max.length; ++i) {
            int m;
            int n;
            if ((n = intervals[j++]) < (m = intervals[j++])) {
                min[i] = n;
                max[i] = m;
                continue;
            }
            min[i] = m;
            max[i] = n;
        }
        return UnicodeSet.valueOf(min, max);
    }

    public static UnicodeSet fromIntervals(int[] intervals) {
        int length = intervals.length;
        if (length % 2 > 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return EMPTY;
        }
        int size = length / 2;
        int[] min = new int[size];
        int[] max = new int[size];
        int j = 0;
        for (int i = 0; i < min.length; ++i) {
            int m;
            int n;
            if ((n = UnicodeSet.alignElement(intervals[j++])) < (m = UnicodeSet.alignElement(intervals[j++]))) {
                min[i] = n;
                max[i] = m;
                continue;
            }
            min[i] = m;
            max[i] = n;
        }
        return UnicodeSet.valueOf(min, max);
    }

    private static UnicodeSet valueOf(int[] min, int[] max) {
        Arrays.sort(min);
        Arrays.sort(max);
        int n = 0;
        int size = 0;
        for (int i = 1; i < min.length; ++i) {
            if (min[i] <= max[i - 1] + 1) continue;
            min[size] = min[n];
            max[size] = max[i - 1];
            ++size;
            n = i;
        }
        min[size] = min[n];
        max[size] = max[max.length - 1];
        if (++size == 1 && min[0] == 0 && max[0] == 0x10FFFF) {
            return WHOLE;
        }
        if (size == max.length) {
            return new UnicodeSet(min, max);
        }
        return new UnicodeSet(Arrays.copyOf(min, size), Arrays.copyOf(max, size));
    }

    private static int alignElement(int ch) {
        return ch < 0 ? 0 : (ch > 0x10FFFF ? 0x10FFFF : ch);
    }

    public static String escape(char ch) {
        switch (ch) {
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        if (PRINT.contains(ch)) {
            return Character.toString(ch);
        }
        char[] ucode = new char[]{'\\', 'u', '0', '0', '0', '0'};
        for (int i = 3; i >= 0; --i) {
            int x;
            ucode[5 - i] = (char)(x + ((x = ch >> i * 4 & 0xF) > 9 ? 87 : 48));
        }
        return new String(ucode);
    }

    public static String escape(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return UnicodeSet.escape(source, new StringBuilder(source.length())).toString();
    }

    public static StringBuilder escape(String source, StringBuilder buf) {
        int length = source == null ? 0 : source.length();
        for (int i = 0; i < length; ++i) {
            buf.append(UnicodeSet.escape(source.charAt(i)));
        }
        return buf;
    }

    public static String unescape(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return UnicodeSet.unescape(source, new StringBuilder(source.length())).toString();
    }

    public static StringBuilder unescape(String source, StringBuilder buf) {
        int length = source == null ? 0 : source.length();
        int i = 0;
        while (i < length) {
            char ch;
            if ((ch = source.charAt(i++)) == '\\') {
                if (i == length) {
                    throw new IllegalArgumentException(source);
                }
                switch (source.charAt(i++)) {
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 'u': {
                        if (i + 4 > length) {
                            throw new IllegalArgumentException(source);
                        }
                        int ucode = 0;
                        for (int j = 0; j < 4; ++j) {
                            ucode <<= 4;
                            if ((ch = source.charAt(i++)) >= '0' && ch <= '9') {
                                ucode |= ch - 48;
                                continue;
                            }
                            if (ch >= 'a' && ch <= 'z') {
                                ucode |= ch - 87;
                                continue;
                            }
                            if (ch >= 'A' && ch <= 'Z') {
                                ucode |= ch - 55;
                                continue;
                            }
                            throw new IllegalArgumentException(source);
                        }
                        buf.append((char)ucode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(source);
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        return buf;
    }
}

