/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class Location
implements Comparable<Location>,
Serializable {
    private static final long serialVersionUID = -6872809804356827786L;
    public static final Location UNKNOWN = new Location(null, 0, 0);
    public final String file;
    public final int line;
    public final int column;

    private Location(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    @Override
    public int compareTo(Location other) {
        int c;
        if (this.file != other.file) {
            if (this.file == null) {
                return -1;
            }
            if (other.file == null) {
                return 1;
            }
            c = this.file.compareTo(other.file);
            if (c != 0) {
                return c;
            }
        }
        return (c = this.line - other.line) == 0 ? this.column - other.column : c;
    }

    public int hashCode() {
        int hash = this.file == null ? 0 : this.file.hashCode();
        hash = 31 * hash + this.line;
        hash = 31 * hash + this.column;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            if (this.line == other.line && this.column == other.column) {
                return this.file == null ? other.file == null : this.file.equals(other.file);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        if (this.file != null) {
            buf.append(this.file);
        }
        if (this.line > 0) {
            if (this.file != null) {
                buf.append(':');
            }
            buf.append(this.line);
            if (this.column > 0) {
                buf.append(':');
                buf.append(this.column);
            }
        } else if (this.file == null) {
            buf.append("unknown");
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return UNKNOWN.equals(this) ? UNKNOWN : this;
    }

    public static Location valueOf(String file) {
        if (file == null || (file = file.trim()).isEmpty()) {
            return UNKNOWN;
        }
        return new Location(file, 0, 0);
    }

    public static Location valueOf(int line, int column) {
        if (line > 0) {
            return new Location(null, line, column < 0 ? 0 : column);
        }
        return column > 0 ? new Location(null, 1, column) : UNKNOWN;
    }

    public static Location valueOf(String file, int line, int column) {
        if (file == null || (file = file.trim()).isEmpty()) {
            return Location.valueOf(line, column);
        }
        if (line > 0) {
            return new Location(file, line, column < 0 ? 0 : column);
        }
        return column > 0 ? new Location(file, 1, column) : UNKNOWN;
    }
}

