/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ByteBuffer
implements Serializable {
    private static final long serialVersionUID = 2395415332291976964L;
    protected byte[] data;
    protected int length;

    public ByteBuffer() {
        this(512);
    }

    public ByteBuffer(int capacity) {
        this.data = new byte[capacity];
    }

    public ByteBuffer(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteBuffer(byte[] array, int offset, int count) {
        this.length = count;
        this.data = new byte[this.length];
        System.arraycopy(array, offset, this.data, 0, count);
    }

    public int length() {
        return this.length;
    }

    public ByteBuffer append(byte value) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length++] = value;
        return this;
    }

    public ByteBuffer append(byte[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(byte[] array, int offset, int count) {
        this.ensureCapacity(this.length + count);
        System.arraycopy(array, offset, this.data, this.length, count);
        this.length += count;
        return this;
    }

    public ByteBuffer append(short value) {
        this.ensureCapacity(this.length + 2);
        this.data[this.length++] = (byte)(value >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(value >>> 0 & 0xFF);
        return this;
    }

    public ByteBuffer append(short[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(short[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 2);
        for (int i = 0; i < count; ++i) {
            this.append(array[offset + i]);
        }
        return this;
    }

    public ByteBuffer append(int value) {
        this.ensureCapacity(this.length + 4);
        this.data[this.length++] = (byte)(value >>> 24 & 0xFF);
        this.data[this.length++] = (byte)(value >>> 16 & 0xFF);
        this.data[this.length++] = (byte)(value >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(value >>> 0 & 0xFF);
        return this;
    }

    public ByteBuffer append(int[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(int[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 4);
        for (int i = 0; i < count; ++i) {
            this.append(array[offset + i]);
        }
        return this;
    }

    public ByteBuffer append(long value) {
        this.ensureCapacity(this.length + 8);
        this.data[this.length++] = (byte)(value >>> 56 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 48 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 40 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 32 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 24 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 16 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 8 & 0xFFL);
        this.data[this.length++] = (byte)(value >>> 0 & 0xFFL);
        return this;
    }

    public ByteBuffer append(long[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(long[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 8);
        for (int i = 0; i < count; ++i) {
            this.append(array[offset + i]);
        }
        return this;
    }

    public ByteBuffer append(float value) {
        return this.append(Float.floatToIntBits(value));
    }

    public ByteBuffer append(float[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(float[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 4);
        for (int i = 0; i < count; ++i) {
            this.append(Float.floatToIntBits(array[offset + i]));
        }
        return this;
    }

    public ByteBuffer append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    public ByteBuffer append(double[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(double[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 8);
        for (int i = 0; i < count; ++i) {
            this.append(Double.doubleToLongBits(array[offset + i]));
        }
        return this;
    }

    public ByteBuffer append(char value) {
        return this.append((short)value);
    }

    public ByteBuffer append(char[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(char[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 8);
        for (int i = 0; i < count; ++i) {
            this.append((short)array[offset + i]);
        }
        return this;
    }

    public ByteBuffer append(boolean value) {
        return this.append(value ? (byte)1 : 0);
    }

    public ByteBuffer append(boolean[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteBuffer append(boolean[] array, int offset, int count) {
        this.ensureCapacity(this.length + count * 8);
        for (int i = 0; i < count; ++i) {
            this.append(array[offset + i] ? (byte)1 : 0);
        }
        return this;
    }

    public ByteBuffer append(ByteBuffer buffer) {
        return this.append(buffer.data, 0, buffer.length);
    }

    public void reset() {
        this.length = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            int len = this.data.length * 3 / 2 + 1;
            byte[] buf = new byte[len > capacity ? len : capacity];
            System.arraycopy(this.data, 0, buf, 0, this.length);
            this.data = buf;
        }
    }

    public byte[] getBytes() {
        byte[] buf = new byte[this.length];
        System.arraycopy(this.data, 0, buf, 0, buf.length);
        return buf;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.length);
        stream.write(this.data, 0, this.length);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.data = new byte[stream.readInt()];
        this.length = stream.read(this.data);
        if (this.length != this.data.length) {
            throw new IOException();
        }
    }
}

