/*
 * Decompiled with CFR 0.152.
 */
package com.foxcode.android.common.nointernet.utils;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.widget.Toast;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/foxcode/android/common/nointernet/utils/NoInternetUtils;", "", "()V", "hasActiveInternetConnection", "", "isAirplaneModeOn", "context", "Landroid/content/Context;", "isConnectedToInternet", "turnOffAirplaneMode", "", "turnOnMobileData", "turnOnWifi", "fox_common_release"})
public final class NoInternetUtils {
    @NotNull
    public static final NoInternetUtils INSTANCE = new NoInternetUtils();

    private NoInternetUtils() {
    }

    @JvmStatic
    public static final boolean isConnectedToInternet(@NotNull Context context) {
        NetworkInfo activeNetwork;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkInfo networkInfo = activeNetwork = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null ? networkInfo.isConnected() : false;
    }

    @JvmStatic
    public static final boolean isAirplaneModeOn(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    @JvmStatic
    public static final boolean hasActiveInternetConnection() {
        try {
            URLConnection uRLConnection = new URL("https://www.google.com").openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection urlConnection = (HttpURLConnection)uRLConnection;
            urlConnection.setRequestProperty("User-Agent", "Test");
            urlConnection.setRequestProperty("Connection", "close");
            urlConnection.setConnectTimeout(1500);
            urlConnection.connect();
            return urlConnection.getResponseCode() == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @JvmStatic
    public static final void turnOnMobileData(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            context.startActivity(new Intent("android.settings.SETTINGS"));
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)context, (CharSequence)"It cannot open settings!", (int)1).show();
        }
    }

    @JvmStatic
    public static final void turnOnWifi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            context.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)context, (CharSequence)"It cannot open settings!", (int)1).show();
        }
    }

    @JvmStatic
    public static final void turnOffAirplaneMode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            context.startActivity(new Intent("android.settings.AIRPLANE_MODE_SETTINGS"));
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)context, (CharSequence)"It cannot open settings!", (int)1).show();
        }
    }
}

