/*
 * Decompiled with CFR 0.152.
 */
package com.foxcode.android.common.nointernet.ui;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.lifecycle.Lifecycle;
import com.foxcode.android.common.R;
import com.foxcode.android.common.databinding.DialogNoInternetBinding;
import com.foxcode.android.common.nointernet.ui.DialogProperties;
import com.foxcode.android.common.nointernet.ui.base.BaseNoInternetDialog;
import com.foxcode.android.common.nointernet.utils.NoInternetUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0019B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\r\u0010\r\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/foxcode/android/common/nointernet/ui/NoInternetDialog;", "Lcom/foxcode/android/common/nointernet/ui/base/BaseNoInternetDialog;", "activity", "Landroid/app/Activity;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "dialogProperties", "Lcom/foxcode/android/common/nointernet/ui/DialogProperties;", "(Landroid/app/Activity;Landroidx/lifecycle/Lifecycle;Lcom/foxcode/android/common/nointernet/ui/DialogProperties;)V", "binding", "Lcom/foxcode/android/common/databinding/DialogNoInternetBinding;", "initListeners", "", "initView", "initView$fox_common_release", "onDestroy", "onDestroy$fox_common_release", "onDismiss", "onDismiss$fox_common_release", "onShow", "isAirplaneModeOn", "", "onShow$fox_common_release", "setLayout", "setLayout$fox_common_release", "Builder", "fox_common_release"})
public final class NoInternetDialog
extends BaseNoInternetDialog {
    @NotNull
    private final DialogProperties dialogProperties;
    private DialogNoInternetBinding binding;

    private NoInternetDialog(Activity activity, Lifecycle lifecycle, DialogProperties dialogProperties) {
        super(activity, lifecycle, dialogProperties, R.style.Dialog_NoInternet);
        this.dialogProperties = dialogProperties;
    }

    @Override
    public void setLayout$fox_common_release() {
        DialogNoInternetBinding dialogNoInternetBinding = DialogNoInternetBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)dialogNoInternetBinding, (String)"inflate(...)");
        this.binding = dialogNoInternetBinding;
        DialogNoInternetBinding dialogNoInternetBinding2 = this.binding;
        if (dialogNoInternetBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding2 = null;
        }
        this.setContentView((View)dialogNoInternetBinding2.getRoot());
    }

    @Override
    public void initView$fox_common_release() {
        DialogNoInternetBinding dialogNoInternetBinding = this.binding;
        if (dialogNoInternetBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding = null;
        }
        dialogNoInternetBinding.tvTitle.setText((CharSequence)this.dialogProperties.getNoInternetConnectionTitle());
        DialogNoInternetBinding dialogNoInternetBinding2 = this.binding;
        if (dialogNoInternetBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding2 = null;
        }
        dialogNoInternetBinding2.tvMessage.setText((CharSequence)this.dialogProperties.getNoInternetConnectionMessage());
        DialogNoInternetBinding dialogNoInternetBinding3 = this.binding;
        if (dialogNoInternetBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding3 = null;
        }
        dialogNoInternetBinding3.btnWifiOn.setText((CharSequence)this.dialogProperties.getWifiOnButtonText());
        DialogNoInternetBinding dialogNoInternetBinding4 = this.binding;
        if (dialogNoInternetBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding4 = null;
        }
        dialogNoInternetBinding4.btnMobileDataOn.setText((CharSequence)this.dialogProperties.getMobileDataOnButtonText());
        this.initListeners();
    }

    private final void initListeners() {
        DialogNoInternetBinding dialogNoInternetBinding = this.binding;
        if (dialogNoInternetBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding = null;
        }
        dialogNoInternetBinding.btnWifiOn.setOnClickListener(arg_0 -> NoInternetDialog.initListeners$lambda$0(this, arg_0));
        DialogNoInternetBinding dialogNoInternetBinding2 = this.binding;
        if (dialogNoInternetBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogNoInternetBinding2 = null;
        }
        dialogNoInternetBinding2.btnMobileDataOn.setOnClickListener(arg_0 -> NoInternetDialog.initListeners$lambda$1(this, arg_0));
    }

    @Override
    public void onShow$fox_common_release(boolean isAirplaneModeOn) {
    }

    @Override
    public void onDismiss$fox_common_release() {
    }

    @Override
    public void onDestroy$fox_common_release() {
    }

    private static final void initListeners$lambda$0(NoInternetDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        NoInternetUtils.turnOnWifi(context);
    }

    private static final void initListeners$lambda$1(NoInternetDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        NoInternetUtils.turnOnMobileData(context);
    }

    public /* synthetic */ NoInternetDialog(Activity activity, Lifecycle lifecycle, DialogProperties dialogProperties, DefaultConstructorMarker $constructor_marker) {
        this(activity, lifecycle, dialogProperties);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/foxcode/android/common/nointernet/ui/NoInternetDialog$Builder;", "", "activity", "Landroid/app/Activity;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroid/app/Activity;Landroidx/lifecycle/Lifecycle;)V", "dialogProperties", "Lcom/foxcode/android/common/nointernet/ui/DialogProperties;", "getDialogProperties", "()Lcom/foxcode/android/common/nointernet/ui/DialogProperties;", "build", "Lcom/foxcode/android/common/nointernet/ui/NoInternetDialog;", "fox_common_release"})
    public static final class Builder {
        @NotNull
        private final Activity activity;
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final DialogProperties dialogProperties;

        public Builder(@NotNull Activity activity, @NotNull Lifecycle lifecycle) {
            DialogProperties dialogProperties;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            this.activity = activity;
            this.lifecycle = lifecycle;
            this.dialogProperties = new DialogProperties(false, null, null, null, null, null, 63, null);
            DialogProperties $this$_init__u24lambda_u240 = dialogProperties = this.dialogProperties;
            boolean bl = false;
            $this$_init__u24lambda_u240.setCancelable(false);
            $this$_init__u24lambda_u240.setConnectionCallback(null);
            String string2 = this.activity.getString(R.string.fox_common_no_internet_connection_default_title);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            $this$_init__u24lambda_u240.setNoInternetConnectionTitle(string2);
            String string3 = this.activity.getString(R.string.fox_common_no_internet_connection_default_message);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            $this$_init__u24lambda_u240.setNoInternetConnectionMessage(string3);
            String string4 = this.activity.getString(R.string.fox_common_turn_on_wifi_cta);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            $this$_init__u24lambda_u240.setWifiOnButtonText(string4);
            String string5 = this.activity.getString(R.string.fox_common_turn_on_mobile_data_cta);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            $this$_init__u24lambda_u240.setMobileDataOnButtonText(string5);
        }

        @NotNull
        public final DialogProperties getDialogProperties() {
            return this.dialogProperties;
        }

        @NotNull
        public final NoInternetDialog build() {
            return new NoInternetDialog(this.activity, this.lifecycle, this.dialogProperties, null);
        }
    }
}

