/*
 * Decompiled with CFR 0.152.
 */
package com.foxcode.android.common.nointernet.components;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.util.Log;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.foxcode.android.common.nointernet.utils.NoInternetUtils;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0007J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\b\u0010\u0017\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent;", "Landroidx/lifecycle/LifecycleObserver;", "applicationContext", "Landroid/content/Context;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "listener", "Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent$NoInternetObserverListener;", "(Landroid/content/Context;Landroidx/lifecycle/Lifecycle;Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent$NoInternetObserverListener;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "connectivityManagerCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentJob", "Lkotlinx/coroutines/Job;", "checkInternetAndInvokeListener", "", "getConnectivityManagerCallback", "initReceivers", "start", "stop", "updateConnection", "Companion", "NoInternetObserverListener", "fox_common_release"})
public final class NoInternetObserveComponent
implements LifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final NoInternetObserverListener listener;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job currentJob;
    @NotNull
    private ConnectivityManager connectivityManager;
    @Nullable
    private ConnectivityManager.NetworkCallback connectivityManagerCallback;
    @NotNull
    private static final String TAG = "NoInternetObserve";

    public NoInternetObserveComponent(@NotNull Context applicationContext, @NotNull Lifecycle lifecycle, @NotNull NoInternetObserverListener listener) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.applicationContext = applicationContext;
        this.listener = listener;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        Object object = this.applicationContext.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    private final void initReceivers() {
        this.updateConnection();
        NetworkRequest.Builder builder = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).addTransportType(3).removeCapability(15);
        this.connectivityManager.registerNetworkCallback(builder.build(), this.getConnectivityManagerCallback());
    }

    private final void updateConnection() {
        NetworkInfo activeNetwork;
        NetworkInfo networkInfo = activeNetwork = this.connectivityManager.getActiveNetworkInfo();
        boolean bl = networkInfo != null ? networkInfo.isConnected() : false;
        if (bl) {
            Log.d((String)TAG, (String)"activeNetwork?.isConnected == true");
            this.listener.onConnected();
        } else {
            Log.d((String)TAG, (String)"activeNetwork?.isConnected != true");
            this.checkInternetAndInvokeListener();
        }
    }

    private final ConnectivityManager.NetworkCallback getConnectivityManagerCallback() {
        ConnectivityManager.NetworkCallback networkCallback = this.connectivityManagerCallback = (ConnectivityManager.NetworkCallback)new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NoInternetObserveComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"NoInternetObserve", (String)("onAvailable(): " + network));
                NoInternetObserveComponent.access$getListener$p(this.this$0).onConnected();
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"NoInternetObserve", (String)("onLost(): " + network));
                NoInternetObserveComponent.access$checkInternetAndInvokeListener(this.this$0);
            }
        };
        Intrinsics.checkNotNull((Object)networkCallback);
        return networkCallback;
    }

    private final void checkInternetAndInvokeListener() {
        this.currentJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NoInternetObserveComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        boolean hasActiveConnection = NoInternetUtils.isConnectedToInternet(NoInternetObserveComponent.access$getApplicationContext$p(this.this$0));
                        if (!hasActiveConnection) {
                            BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ NoInternetObserveComponent this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            NoInternetObserveComponent.access$getListener$p(this.this$0).onDisconnected(NoInternetUtils.isAirplaneModeOn(NoInternetObserveComponent.access$getApplicationContext$p(this.this$0)));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public final void start() {
        Log.d((String)TAG, (String)"start");
        this.listener.onStart();
        this.initReceivers();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public final void stop() {
        Log.d((String)TAG, (String)"stop");
        ConnectivityManager.NetworkCallback networkCallback = this.connectivityManagerCallback;
        if (networkCallback != null) {
            ConnectivityManager.NetworkCallback it = networkCallback;
            boolean bl = false;
            try {
                this.connectivityManager.unregisterNetworkCallback(it);
            }
            catch (Exception exception) {
            }
        }
        Job job = this.currentJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.listener.onStop();
    }

    public static final /* synthetic */ NoInternetObserverListener access$getListener$p(NoInternetObserveComponent $this) {
        return $this.listener;
    }

    public static final /* synthetic */ void access$checkInternetAndInvokeListener(NoInternetObserveComponent $this) {
        $this.checkInternetAndInvokeListener();
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(NoInternetObserveComponent $this) {
        return $this.applicationContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent$Companion;", "", "()V", "TAG", "", "fox_common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\u0003H&\u00a8\u0006\t"}, d2={"Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent$NoInternetObserverListener;", "", "onConnected", "", "onDisconnected", "isAirplaneModeOn", "", "onStart", "onStop", "fox_common_release"})
    public static interface NoInternetObserverListener {
        public void onStart();

        public void onConnected();

        public void onDisconnected(boolean var1);

        public void onStop();
    }
}

