/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.map.BunchedSerializationException;
import com.apple.foundationdb.map.BunchedSerializer;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class BunchedTupleSerializer
implements BunchedSerializer<Tuple, Tuple> {
    @Nonnull
    static final byte[] PREFIX = new byte[]{16};
    private static final BunchedTupleSerializer INSTANCE = new BunchedTupleSerializer();

    public static BunchedTupleSerializer instance() {
        return INSTANCE;
    }

    private BunchedTupleSerializer() {
    }

    @Override
    @Nonnull
    public byte[] serializeKey(@Nonnull Tuple key) {
        try {
            return key.pack();
        }
        catch (IllegalArgumentException e) {
            throw new BunchedSerializationException("unable so serialize key", e).setValue(key);
        }
    }

    @Override
    @Nonnull
    public byte[] serializeEntry(@Nonnull Tuple key, @Nonnull Tuple value) {
        try {
            return Tuple.from((Object[])new Object[]{key, value}).pack();
        }
        catch (IllegalArgumentException e) {
            throw new BunchedSerializationException("unable to serialize entry", e).setValue(Tuple.from((Object[])new Object[]{key, value}));
        }
    }

    @Override
    @Nonnull
    public byte[] serializeEntries(@Nonnull List<Map.Entry<Tuple, Tuple>> entries) {
        if (entries.isEmpty()) {
            throw new BunchedSerializationException("cannot serialize empty entry list");
        }
        ArrayList<byte[]> serializedEntries = new ArrayList<byte[]>(1 + entries.size());
        serializedEntries.add(PREFIX);
        if (!entries.isEmpty()) {
            Iterator<Map.Entry<Tuple, Tuple>> iterator = entries.iterator();
            Map.Entry<Tuple, Tuple> firstEntry = iterator.next();
            serializedEntries.add(Tuple.from((Object[])new Object[]{firstEntry.getValue()}).pack());
            while (iterator.hasNext()) {
                Map.Entry<Tuple, Tuple> entry = iterator.next();
                serializedEntries.add(this.serializeEntry(entry));
            }
        }
        return ByteArrayUtil.join(null, serializedEntries);
    }

    @Override
    @Nonnull
    public Tuple deserializeKey(@Nonnull byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new BunchedSerializationException("offset (" + offset + ") or length " + length + " out of range (" + data.length + ")").setData(data);
        }
        try {
            return Tuple.fromBytes((byte[])data, (int)offset, (int)length);
        }
        catch (RuntimeException e) {
            throw new BunchedSerializationException("unable to deserialize key", e).setData(Arrays.copyOfRange(data, offset, offset + length));
        }
    }

    @Nonnull
    private static Tuple toTuple(@Nonnull Object o) {
        if (o instanceof Tuple) {
            return (Tuple)o;
        }
        return Tuple.fromItems((Iterable)((Iterable)o));
    }

    @Override
    @Nonnull
    public List<Map.Entry<Tuple, Tuple>> deserializeEntries(@Nonnull Tuple key, @Nonnull byte[] data) {
        if (!ByteArrayUtil.startsWith((byte[])data, (byte[])PREFIX)) {
            throw new BunchedSerializationException("data did not begin with expected prefix").setData(data);
        }
        Tuple entriesTuple = Tuple.fromBytes((byte[])data, (int)PREFIX.length, (int)(data.length - PREFIX.length));
        if (entriesTuple.size() % 2 == 0) {
            throw new BunchedSerializationException("deserialized entry list had incorrect number of elements");
        }
        Iterator tupleIterator = entriesTuple.iterator();
        ArrayList<Map.Entry<Tuple, Tuple>> entryList = new ArrayList<Map.Entry<Tuple, Tuple>>(entriesTuple.size() / 2);
        boolean first = true;
        while (tupleIterator.hasNext()) {
            Tuple entryKey = null;
            Tuple entryValue = null;
            try {
                if (first) {
                    entryKey = key;
                    first = false;
                } else {
                    entryKey = BunchedTupleSerializer.toTuple(tupleIterator.next());
                }
                entryValue = BunchedTupleSerializer.toTuple(tupleIterator.next());
                entryList.add(new AbstractMap.SimpleImmutableEntry<Tuple, Tuple>(entryKey, entryValue));
            }
            catch (ClassCastException e) {
                throw new BunchedSerializationException("deserialized entry list did not consist only of tuples", e);
            }
        }
        return entryList;
    }

    @Override
    public boolean canAppend() {
        return true;
    }
}

