/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.annotation.API;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface BunchedSerializer<K, V> {
    @Nonnull
    public byte[] serializeKey(@Nonnull K var1);

    @Nonnull
    public byte[] serializeEntry(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    default public byte[] serializeEntry(@Nonnull Map.Entry<K, V> entry) {
        return this.serializeEntry(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public byte[] serializeEntries(@Nonnull List<Map.Entry<K, V>> var1);

    @Nonnull
    default public K deserializeKey(@Nonnull byte[] data) {
        return this.deserializeKey(data, 0, data.length);
    }

    @Nonnull
    default public K deserializeKey(@Nonnull byte[] data, int offset) {
        return this.deserializeKey(data, offset, data.length - offset);
    }

    @Nonnull
    public K deserializeKey(@Nonnull byte[] var1, int var2, int var3);

    @Nonnull
    public List<Map.Entry<K, V>> deserializeEntries(@Nonnull K var1, @Nonnull byte[] var2);

    @Nonnull
    default public List<K> deserializeKeys(@Nonnull K key, @Nonnull byte[] data) {
        return this.deserializeEntries(key, data).stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    default public boolean canAppend() {
        return false;
    }
}

