/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncPeekCallbackIterator;
import com.apple.foundationdb.async.AsyncUtil;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class WrappingAsyncPeekIterator<T>
implements AsyncPeekCallbackIterator<T> {
    @Nonnull
    private AsyncIterator<T> underlying;
    @Nullable
    private CompletableFuture<Boolean> hasNextFuture;
    private boolean done;
    private boolean hasCurrent;
    @Nullable
    private T nextItem;
    @Nonnull
    private Consumer<T> callback;

    WrappingAsyncPeekIterator(@Nonnull AsyncIterator<T> underlying) {
        this(underlying, t -> {});
    }

    WrappingAsyncPeekIterator(@Nonnull AsyncIterator<T> underlying, @Nonnull Consumer<T> callback) {
        this.underlying = underlying;
        this.callback = callback;
        this.done = false;
        this.hasCurrent = false;
    }

    public CompletableFuture<Boolean> onHasNext() {
        if (this.done) {
            return AsyncUtil.READY_FALSE;
        }
        if (this.hasCurrent) {
            return AsyncUtil.READY_TRUE;
        }
        if (this.hasNextFuture == null) {
            this.hasNextFuture = this.underlying.onHasNext().thenApply(doesHaveNext -> {
                if (doesHaveNext.booleanValue()) {
                    this.hasCurrent = true;
                    this.nextItem = this.underlying.next();
                    this.callback.accept(this.nextItem);
                } else {
                    this.done = true;
                }
                return doesHaveNext;
            });
        }
        return this.hasNextFuture;
    }

    public boolean hasNext() {
        return this.onHasNext().join();
    }

    @Override
    public T peek() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        if (this.hasCurrent || this.hasNext()) {
            return this.nextItem;
        }
        throw new NoSuchElementException();
    }

    public T next() {
        T val = this.peek();
        this.hasNextFuture = null;
        this.hasCurrent = false;
        return val;
    }

    public void cancel() {
        this.underlying.cancel();
    }

    @Override
    public void setCallback(@Nonnull Consumer<T> callback) {
        this.callback = callback;
    }

    @Override
    @Nonnull
    public Consumer<T> getCallback() {
        return this.callback;
    }
}

