/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.valuegens;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.utils.GenericProxyHandler;
import org.force66.beantester.valuegens.ValueGenerator;

public class InterfaceValueGenerator
implements ValueGenerator<Object> {
    private Class<?> interfaceType;

    public InterfaceValueGenerator(Class<?> type) {
        Validate.notNull(type, (String)"Null interface type not allowed", (Object[])new Object[0]);
        Validate.isTrue((boolean)type.isInterface(), (String)"Provided class must be an interface.  class=%s", (Object[])new Object[]{type.getName()});
        this.interfaceType = type;
    }

    @Override
    public Object[] makeValues() {
        return new Object[]{Proxy.newProxyInstance(this.interfaceType.getClassLoader(), new Class[]{this.interfaceType}, (InvocationHandler)new GenericProxyHandler(this.interfaceType))};
    }

    @Override
    public boolean canGenerate(Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        return targetClass.isInterface();
    }
}

