/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.valuegens.ValueGenerator;
import org.force66.beantester.valuegens.ValueGeneratorFactory;

public class InstantiationUtils {
    public static Object safeNewInstance(Class<?> klass) {
        return InstantiationUtils.safeNewInstance(klass, null);
    }

    public static Object safeNewInstance(ValueGeneratorFactory factory, Class<?> klass) {
        Validate.notNull(klass, (String)"Null class not allowed.", (Object[])new Object[0]);
        Constructor<?> ctor = InstantiationUtils.findPublicConstructor(klass);
        if (ctor == null) {
            throw new BeanTesterException("No public constructor found -- value generation isn't possible").addContextValue("class", klass.getName());
        }
        if (ctor.getParameterTypes().length == 0) {
            return InstantiationUtils.safeNewInstance(klass, null);
        }
        ValueGenerator<?> generator = null;
        ArrayList constructorArgs = new ArrayList();
        for (Class<?> argType : ctor.getParameterTypes()) {
            generator = factory.forClass(argType);
            if (generator == null) {
                throw new BeanTesterException("Value can't be generated for constructor argument").addContextValue("class", klass.getName()).addContextValue("constructor", ctor).addContextValue("argument type", (Object)argType.getName());
            }
            constructorArgs.add(generator.makeValues()[0]);
        }
        return InstantiationUtils.safeNewInstance(klass, constructorArgs.toArray());
    }

    public static Constructor<?> findPublicConstructor(Class<?> klass) {
        Constructor<?>[] constructorArray;
        Validate.notNull(klass, (String)"Null class not allowed.", (Object[])new Object[0]);
        Constructor nullConstructor = ConstructorUtils.getAccessibleConstructor(klass, (Class[])new Class[0]);
        if (nullConstructor != null) {
            return nullConstructor;
        }
        for (Constructor<?> constructor : constructorArray = klass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            return constructor;
        }
        return null;
    }

    public static Object safeNewInstance(Class<?> klass, Object[] constructorArgs) {
        Validate.notNull(klass, (String)"Null class not allowed.", (Object[])new Object[0]);
        try {
            return ConstructorUtils.invokeConstructor(klass, (Object[])constructorArgs);
        }
        catch (Exception e) {
            throw new BeanTesterException("Failed to instantiate bean using newInstance()", e).addContextValue("className", klass.getName());
        }
    }

    public static XMLGregorianCalendar newXMLGregorianCalendar() {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            throw new BeanTesterException("This shouldn't happen", e);
        }
    }
}

