/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.tests;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.tests.BaseBeanTest;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.utils.InjectionUtils;
import org.force66.beantester.utils.InstantiationUtils;
import org.force66.beantester.valuegens.ValueGeneratorFactory;

public class SerializableTest
extends BaseBeanTest {
    private ValueGeneratorFactory valueGeneratorFactory;

    public SerializableTest(ValueGeneratorFactory factory) {
        Validate.notNull((Object)factory, (String)"Null ValueGeneratorFactory not allowed.", (Object[])new Object[0]);
        this.valueGeneratorFactory = factory;
    }

    @Override
    public boolean testBeanClass(Class<?> klass, Object[] constructorArgs) {
        this.setFailureReason(null);
        Object bean = InstantiationUtils.safeNewInstance(klass, constructorArgs);
        if (bean instanceof Serializable) {
            InjectionUtils.injectValues(bean, this.valueGeneratorFactory, false);
            Serializable sBean = (Serializable)bean;
            Serializable sBeanReconstituted = null;
            try {
                byte[] serializedObj = SerializationUtils.serialize((Serializable)sBean);
                sBeanReconstituted = (Serializable)SerializationUtils.deserialize((byte[])serializedObj);
            }
            catch (Throwable e) {
                this.setFailureReason("Error serializing bean that implements serializable");
                throw new BeanTesterException("Error serializing bean that implements serializable", e).addContextValue("class", klass.getName());
            }
            Method equalsMethod = MethodUtils.getAccessibleMethod(klass, (String)"equals", Object.class);
            if (!equalsMethod.getDeclaringClass().equals(Object.class) && !sBean.equals(sBeanReconstituted)) {
                this.setFailureReason("Bean implements serializable, but the reconstituted bean doesn't equal it's original");
                throw new BeanTesterException("Bean implements serializable, but the reconstituted bean doesn't equal it's original").addContextValue("class", klass.getName());
            }
        }
        return true;
    }
}

