/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.springframework.core.io.ClassPathResource;

public class FlywayHelperFactory {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Flyway flyway;
    private Properties flywayProperties;
    private ClassicConfiguration flywayConfiguration;

    public FlywayHelperFactory() {
        this.logger.info((Object)"Create flyway helper factory.");
    }

    public synchronized Flyway createFlyway() {
        if (this.flyway == null) {
            ClassicConfiguration classicConfiguration;
            this.logger.info((Object)"Create a new flyway instance.");
            Properties configuredProperties = this.getFlywayProperties();
            if (configuredProperties == null) {
                configuredProperties = new Properties();
                this.setFlywayProperties(configuredProperties);
                ClassPathResource classPathResource = new ClassPathResource("flyway.properties");
                InputStream inputStream = null;
                try {
                    inputStream = classPathResource.getInputStream();
                    configuredProperties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Can not load flyway.properties.", (Throwable)e);
                }
                this.setFlywayProperties(configuredProperties);
                this.logger.info((Object)String.format("Load flyway.properties with %d entries.", configuredProperties.size()));
            } else {
                this.logger.info((Object)String.format("Used preconfigured flyway.properties with %d entries.", configuredProperties.size()));
            }
            if (this.flywayConfiguration == null) {
                classicConfiguration = new ClassicConfiguration();
                classicConfiguration.configure(this.getFlywayProperties());
                this.setFlywayConfiguration(classicConfiguration);
            } else {
                classicConfiguration = this.getFlywayConfiguration();
                classicConfiguration.configure(this.getFlywayProperties());
                this.setFlywayConfiguration(classicConfiguration);
            }
            Flyway toReturn = Flyway.configure().configuration((Configuration)this.getFlywayConfiguration()).load();
            this.setFlyway(toReturn);
        }
        return this.flyway;
    }

    public Properties getFlywayProperties() {
        return this.flywayProperties;
    }

    public void setFlywayProperties(Properties flywayProperties) {
        this.flywayProperties = flywayProperties;
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    private void setFlyway(Flyway flyway) {
        this.flyway = flyway;
    }

    public ClassicConfiguration getFlywayConfiguration() {
        return this.flywayConfiguration;
    }

    public void setFlywayConfiguration(ClassicConfiguration flywayConfiguration) {
        this.flywayConfiguration = flywayConfiguration;
    }
}

