/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import org.flywaydb.core.api.FlywayException;

public enum SQLServerEngineEdition {
    PERSONAL_DESKTOP(1),
    STANDARD(2),
    ENTERPRISE(3),
    EXPRESS(4),
    SQL_DATABASE(5),
    SQL_DATA_WAREHOUSE(6),
    MANAGED_INSTANCE(8),
    AZURE_SQL_EDGE(9),
    SYNAPSE_SERVERLESS_POOLS(11),
    FABRIC(12);

    private final int code;

    public static SQLServerEngineEdition fromCode(int code) {
        for (SQLServerEngineEdition edition : SQLServerEngineEdition.values()) {
            if (edition.code != code) continue;
            if (edition == SYNAPSE_SERVERLESS_POOLS) {
                throw new FlywayException("Synapse serverless SQL pool is not currently supported in Flyway");
            }
            return edition;
        }
        throw new IllegalArgumentException("Unknown SQL Server engine edition: " + code);
    }

    private SQLServerEngineEdition(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }
}

