/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.singlestore;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.singlestore.SingleStoreConnection;

public class SingleStoreDatabase
extends Database<SingleStoreConnection> {
    public SingleStoreDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE " + (this.getVersion().isAtLeast("7.3") ? "ROWSTORE" : "") + " TABLE " + table + "(\n    `installed_rank` INT NOT NULL,\n    `version` VARCHAR(50),\n    `description` VARCHAR(200) NOT NULL,\n    `type` VARCHAR(20) NOT NULL,\n    `script` VARCHAR(1000) NOT NULL,\n    `checksum` INT,\n    `installed_by` VARCHAR(100) NOT NULL,\n    `installed_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    `execution_time` INT NOT NULL,\n    `success` BOOL NOT NULL,\n    PRIMARY KEY (`installed_rank`),\n    INDEX (`success`)\n);" + (baseline ? this.getBaselineStatement(table) : "");
    }

    protected SingleStoreConnection doGetConnection(Connection connection) {
        return new SingleStoreConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("7.1");
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((SingleStoreConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUBSTRING_INDEX(USER(),'@',1)", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public String getOpenQuote() {
        return "`";
    }

    public String getCloseQuote() {
        return "`";
    }

    public boolean catalogIsSchema() {
        return true;
    }
}

