/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class GcsmConfigurationExtension
implements ConfigurationExtension {
    private static final Log LOG = LogFactory.getLog(GcsmConfigurationExtension.class);
    private static final String GCSM_PROJECT = "flyway.plugins.gcsm.project";
    private static final String GCSM_SECRETS = "flyway.plugins.gcsm.secrets";
    private static final String GCSM_PROJECT_DEPRECATED = "flyway.gcsm.project";
    private static final String GCSM_SECRETS_DEPRECATED = "flyway.gcsm.secrets";
    private String gcsmProject;
    private String[] gcsmSecrets;

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        if (configuration.containsKey(GCSM_PROJECT_DEPRECATED)) {
            LOG.warn("The 'flyway.gcsm' parameters have been deprecated, and will be replaced with 'flyway.plugins.gcsm'. Update your configuration to use the new names, see: https://rd.gt/3mUUFvE");
            this.extractDeprecatedConfiguration(configuration);
        } else {
            this.extractConfiguration(configuration);
        }
    }

    private void extractConfiguration(Map<String, String> configuration) {
        this.gcsmProject = configuration.getOrDefault(GCSM_PROJECT, this.gcsmProject);
        String gcsmSecretsString = configuration.getOrDefault(GCSM_SECRETS, null);
        if (gcsmSecretsString != null) {
            this.gcsmSecrets = gcsmSecretsString.split(",");
        }
        configuration.remove(GCSM_PROJECT);
        configuration.remove(GCSM_SECRETS);
    }

    private void extractDeprecatedConfiguration(Map<String, String> configuration) {
        this.gcsmProject = configuration.getOrDefault(GCSM_PROJECT_DEPRECATED, this.gcsmProject);
        String gcsmSecretsString = configuration.getOrDefault(GCSM_SECRETS_DEPRECATED, null);
        if (gcsmSecretsString != null) {
            this.gcsmSecrets = gcsmSecretsString.split(",");
        }
        configuration.remove(GCSM_PROJECT_DEPRECATED);
        configuration.remove(GCSM_SECRETS_DEPRECATED);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_GCSM_PROJECT": {
                return GCSM_PROJECT;
            }
            case "FLYWAY_PLUGINS_GCSM_SECRETS": {
                return GCSM_SECRETS;
            }
            case "FLYWAY_GCSM_PROJECT": {
                return GCSM_PROJECT_DEPRECATED;
            }
            case "FLYWAY_GCSM_SECRETS": {
                return GCSM_SECRETS_DEPRECATED;
            }
        }
        return null;
    }

    public void setGcsmSecrets(String ... gcsmSecrets) {
        this.gcsmSecrets = gcsmSecrets;
    }

    public String getGcsmProject() {
        return this.gcsmProject;
    }

    public String[] getGcsmSecrets() {
        return this.gcsmSecrets;
    }

    public void setGcsmProject(String gcsmProject) {
        this.gcsmProject = gcsmProject;
    }
}

