/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.internal.ObjectPool;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ClientResourceStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.UpdateFailureState;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusResponse;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8016")
public final class CsdsService
extends ClientStatusDiscoveryServiceGrpc.ClientStatusDiscoveryServiceImplBase {
    private static final Logger logger = Logger.getLogger(CsdsService.class.getName());
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;

    @VisibleForTesting
    CsdsService(XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolProvider");
    }

    private CsdsService() {
        this(SharedXdsClientPoolProvider.getDefaultProvider());
    }

    public static CsdsService newInstance() {
        return new CsdsService();
    }

    @Override
    public void fetchClientStatus(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        if (this.handleRequest(request, responseObserver)) {
            responseObserver.onCompleted();
        }
    }

    @Override
    public StreamObserver<ClientStatusRequest> streamClientStatus(final StreamObserver<ClientStatusResponse> responseObserver) {
        return new StreamObserver<ClientStatusRequest>(){

            public void onNext(ClientStatusRequest request) {
                CsdsService.this.handleRequest(request, (StreamObserver<ClientStatusResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                this.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private boolean handleRequest(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        try {
            responseObserver.onNext((Object)this.getConfigDumpForRequest(request));
            return true;
        }
        catch (StatusException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected error while building CSDS config dump", e);
            responseObserver.onError((Throwable)new StatusException(Status.INTERNAL.withDescription("Unexpected internal error").withCause((Throwable)e)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientStatusResponse getConfigDumpForRequest(ClientStatusRequest request) throws StatusException {
        if (request.getNodeMatchersCount() > 0) {
            throw new StatusException(Status.INVALID_ARGUMENT.withDescription("node_matchers not supported"));
        }
        ObjectPool<XdsClient> xdsClientPool = this.xdsClientPoolFactory.get();
        if (xdsClientPool == null) {
            return ClientStatusResponse.getDefaultInstance();
        }
        XdsClient xdsClient = null;
        try {
            xdsClient = (XdsClient)xdsClientPool.getObject();
            ClientStatusResponse clientStatusResponse = ClientStatusResponse.newBuilder().addConfig(CsdsService.getClientConfigForXdsClient(xdsClient)).build();
            return clientStatusResponse;
        }
        finally {
            if (xdsClient != null) {
                xdsClientPool.returnObject((Object)xdsClient);
            }
        }
    }

    @VisibleForTesting
    static ClientConfig getClientConfigForXdsClient(XdsClient xdsClient) {
        ClientConfig.Builder builder = ClientConfig.newBuilder().setNode(xdsClient.getBootstrapInfo().node().toEnvoyProtoNode());
        for (AbstractXdsClient.ResourceType type : AbstractXdsClient.ResourceType.values()) {
            if (type == AbstractXdsClient.ResourceType.UNKNOWN) continue;
            Map<String, XdsClient.ResourceMetadata> metadataMap = xdsClient.getSubscribedResourcesMetadata(type);
            for (String resourceName : metadataMap.keySet()) {
                XdsClient.ResourceMetadata metadata = metadataMap.get(resourceName);
                ClientConfig.GenericXdsConfig.Builder genericXdsConfigBuilder = ClientConfig.GenericXdsConfig.newBuilder().setTypeUrl(type.typeUrl()).setName(resourceName).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus()));
                if (metadata.getRawResource() != null) {
                    genericXdsConfigBuilder.setVersionInfo(metadata.getVersion()).setLastUpdated(Timestamps.fromNanos((long)metadata.getUpdateTimeNanos())).setXdsConfig(metadata.getRawResource());
                }
                if (metadata.getStatus() == XdsClient.ResourceMetadata.ResourceMetadataStatus.NACKED) {
                    genericXdsConfigBuilder.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
                }
                builder.addGenericXdsConfigs(genericXdsConfigBuilder);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ClientResourceStatus metadataStatusToClientStatus(XdsClient.ResourceMetadata.ResourceMetadataStatus status) {
        switch (status) {
            case UNKNOWN: {
                return ClientResourceStatus.UNKNOWN;
            }
            case DOES_NOT_EXIST: {
                return ClientResourceStatus.DOES_NOT_EXIST;
            }
            case REQUESTED: {
                return ClientResourceStatus.REQUESTED;
            }
            case ACKED: {
                return ClientResourceStatus.ACKED;
            }
            case NACKED: {
                return ClientResourceStatus.NACKED;
            }
        }
        throw new AssertionError((Object)("Unexpected ResourceMetadataStatus: " + (Object)((Object)status)));
    }

    private static UpdateFailureState metadataUpdateFailureStateToProto(XdsClient.ResourceMetadata.UpdateFailureState errorState) {
        return UpdateFailureState.newBuilder().setLastUpdateAttempt(Timestamps.fromNanos((long)errorState.getFailedUpdateTimeNanos())).setDetails(errorState.getFailedDetails()).setVersionInfo(errorState.getFailedVersion()).build();
    }
}

