/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcDriver
implements Driver {
    private static final String JDBC_API_CLIENT_LIB_TOKEN = "sp-jdbc";
    static final int MAJOR_VERSION = 2;
    static final int MINOR_VERSION = 0;
    private static final String JDBC_URL_FORMAT = "jdbc:(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?");
    private static JdbcDriver registeredDriver;

    @InternalApi
    public static String getClientLibToken() {
        return JDBC_API_CLIENT_LIB_TOKEN;
    }

    static void register() throws SQLException {
        if (JdbcDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        JdbcDriver registeredDriver = new JdbcDriver();
        DriverManager.registerDriver(registeredDriver);
        JdbcDriver.registeredDriver = registeredDriver;
    }

    static void deregister() throws SQLException {
        if (!JdbcDriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        ConnectionOptions.closeSpanner();
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    static boolean isRegistered() {
        return registeredDriver != null;
    }

    static JdbcDriver getRegisteredDriver() throws SQLException {
        if (JdbcDriver.isRegistered()) {
            return registeredDriver;
        }
        throw JdbcSqlExceptionFactory.of("The driver has not been registered", Code.FAILED_PRECONDITION);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url != null && url.startsWith("jdbc:cloudspanner")) {
            try {
                Matcher matcher = URL_PATTERN.matcher(url);
                if (matcher.matches()) {
                    String connectionUri = this.appendPropertiesToUrl(url.substring(5), info);
                    ConnectionOptions options = ConnectionOptions.newBuilder().setUri(connectionUri).build();
                    JdbcConnection connection = new JdbcConnection(url, options);
                    if (options.getWarnings() != null) {
                        connection.pushWarning(new SQLWarning(options.getWarnings()));
                    }
                    return connection;
                }
            }
            catch (SpannerException e) {
                throw JdbcSqlExceptionFactory.of(e);
            }
            catch (IllegalArgumentException e) {
                throw JdbcSqlExceptionFactory.of(e.getMessage(), Code.INVALID_ARGUMENT, e);
            }
            catch (Exception e) {
                throw JdbcSqlExceptionFactory.of(e.getMessage(), Code.UNKNOWN, e);
            }
            throw JdbcSqlExceptionFactory.of("invalid url: " + url, Code.INVALID_ARGUMENT);
        }
        return null;
    }

    private String appendPropertiesToUrl(String url, Properties info) {
        StringBuilder res = new StringBuilder(url);
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            res.append(";").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return res.toString();
    }

    @Override
    public boolean acceptsURL(String url) {
        return URL_PATTERN.matcher(url).matches();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        String connectionUri = this.appendPropertiesToUrl(url.substring(5), info);
        DriverPropertyInfo[] res = new DriverPropertyInfo[ConnectionOptions.VALID_PROPERTIES.size()];
        int i = 0;
        for (ConnectionOptions.ConnectionProperty prop : ConnectionOptions.VALID_PROPERTIES) {
            res[i] = new DriverPropertyInfo(prop.getName(), this.parseUriProperty(connectionUri, prop.getName(), prop.getDefaultValue()));
            res[i].description = prop.getDescription();
            res[i].choices = prop.getValidValues();
            ++i;
        }
        return res;
    }

    private String parseUriProperty(String uri, String property, String defaultValue) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return defaultValue;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            JdbcDriver.register();
        }
        catch (SQLException e) {
            DriverManager.println("Registering driver failed: " + e.getMessage());
        }
    }
}

