/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.teams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.flywaydb.core.api.configuration.S3ClientFactory;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.FeatureDetector;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3OutputStream
extends ByteArrayOutputStream {
    private static final Log LOG = LogFactory.getLog(S3OutputStream.class);
    private final String location;
    private final String bucket;
    private final String key;

    public S3OutputStream(String location) {
        this.location = location;
        int i = location.indexOf("/");
        this.bucket = location.substring(3, i);
        this.key = location.substring(i + 1);
    }

    @Override
    public void close() throws IOException {
        FeatureDetector fd = new FeatureDetector(Thread.currentThread().getContextClassLoader());
        if (fd.isAwsAvailable()) {
            S3Client s3Client = S3ClientFactory.getClient();
            PutObjectRequest objectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(this.key).build();
            s3Client.putObject(objectRequest, RequestBody.fromBytes((byte[])this.toByteArray()));
        } else {
            LOG.error("Can't write to location " + this.location + "; AWS SDK not found");
        }
    }
}

