/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.teams.db2zos;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSDatabase;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSParser;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSParserSqlScript;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public class DB2zOSDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "DB2 z/OS";
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:db2:") || url.startsWith("jdbc:p6spy:db2:");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:db2:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("DB2") && databaseProductVersion.startsWith("DSN");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new DB2zOSDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new DB2zOSParser(configuration, parsingContext);
    }

    @Override
    public SqlScriptFactory createSqlScriptFactory(final Configuration configuration, final ParsingContext parsingContext) {
        return new SqlScriptFactory(){

            @Override
            public SqlScript createSqlScript(LoadableResource resource, boolean mixed, ResourceProvider resourceProvider) {
                return new DB2zOSParserSqlScript(DB2zOSDatabaseType.this.createParser(configuration, resourceProvider, parsingContext), resource, SqlScriptMetadata.getMetadataResource(resourceProvider, resource), mixed);
            }
        };
    }

    @Override
    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("clientProgramName", "Flyway by Redgate");
        props.put("retrieveMessagesFromServerOnGetMessage", "true");
    }
}

