/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.LicenseGuard;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.secretsmanagement.DaprConfigurationExtension;

public class DaprConfigurationProvider
implements ConfigurationProvider<DaprConfigurationExtension> {
    public Map<String, String> getConfiguration(DaprConfigurationExtension configurationExtension, ClassicConfiguration flywayConfiguration) throws Exception {
        boolean isConfigured;
        String daprUrl = configurationExtension.getDaprUrl();
        String[] daprSecrets = configurationExtension.getDaprSecrets();
        boolean bl = isConfigured = daprUrl != null && daprSecrets != null;
        if (!isConfigured) {
            return new HashMap<String, String>();
        }
        String daprConfiguration = DaprConfigurationProvider.getConfiguration(daprUrl, daprSecrets);
        Map daprConfigurationMap = ConfigUtils.loadConfigurationFromString((String)daprConfiguration);
        flywayConfiguration.configure(daprConfigurationMap);
        LicenseGuard.guard((Configuration)flywayConfiguration, Collections.singletonList(Edition.ENTERPRISE), (String)"Dapr");
        ConfigUtils.dumpConfiguration((Map)daprConfigurationMap);
        return daprConfigurationMap;
    }

    public Class<DaprConfigurationExtension> getConfigurationExtensionClass() {
        return DaprConfigurationExtension.class;
    }

    public static String getConfiguration(String url, String ... secrets) throws Exception {
        String urlWithoutSlash = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        StringBuilder daprConf = new StringBuilder();
        for (String secret : secrets) {
            if (!secret.contains("/")) {
                daprConf.append(DaprConfigurationProvider.readSecret(urlWithoutSlash, secret)).append("\n");
                continue;
            }
            daprConf.append(DaprConfigurationProvider.readSecretWithPath(urlWithoutSlash, secret)).append("\n");
        }
        return daprConf.toString();
    }

    private static String readSecretWithPath(String url, String secret) throws Exception {
        if (!secret.startsWith("/")) {
            secret = "/" + secret;
        }
        String path = secret.substring(0, secret.lastIndexOf("/"));
        String secretName = secret.substring(secret.lastIndexOf("/") + 1);
        return DaprConfigurationProvider.readSecret(url + path, secretName);
    }

    private static String readSecret(String url, String secret) throws Exception {
        url = url + "/" + secret;
        URLConnection conn = new URL(url).openConnection();
        return DaprConfigurationProvider.readSecret(conn, secret);
    }

    private static String readSecret(URLConnection conn, String secret) throws Exception {
        JsonObject secretResponse = (JsonObject)new Gson().fromJson(DaprConfigurationProvider.getSecretFromDapr(conn), JsonObject.class);
        JsonObject secretObj = secretResponse.getAsJsonObject();
        if (!secretObj.has(secret)) {
            throw new FlywayException("'" + secret + "' is not a valid Dapr secret");
        }
        return secretObj.get(secret).getAsString();
    }

    private static String getSecretFromDapr(URLConnection conn) throws Exception {
        StringBuilder rawSecret = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                rawSecret.append(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Dapr secret location '" + conn.getURL() + "' could not be found. Ensure the path to your secret is correct.");
        }
        return rawSecret.toString();
    }
}

